@extends('layout.app')

@push('styles')
@endpush

@section('content')
    <div class="card card-body">
        <div class="container">
            <h2>Edit Upazila</h2>
            <form action="{{ route('upazilaUpdate') }}" method="POST">
                @csrf
                @method('POST')

                <input type="hidden" name="id" value="{{ $upazila->id }}">
                <div class="form-group">
                    <label for="district_id">District</label>
                    <select name="district_id" id="district_id" class="form-control select2">
                        <option value="">Select District</option>
                        @foreach ($districts as $item)
                            <option value="{{ $item->id }}" {{ $upazila->district_id == $item->id ? 'selected' : '' }}>
                                {{ $item->name }} -- {{ $item->bn_name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="name">Name(English)</label>
                    <input type="text" name="name" class="form-control" value="{{ $upazila->name }}"
                        placeholder="name">
                </div>

                <div class="form-group">
                    <label for="bn_name">Name(Bengali)</label>
                    <input type="text" name="bn_name" class="form-control" value="{{ $upazila->bn_name }}"
                        placeholder="name bengali">
                </div>

                <button type="submit" class="btn btn-primary">Update Location</button>
            </form>
        </div>
    </div>
@endsection


@section('ajax')
    <script></script>
@endsection
