<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class SearchResultExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function headings(): array
    {
        $dataArray = [
            'ID',
            'Username',
            'password',
            'code',
            'Status',
            'Expire',
            'B Cycle',
            'Package',
            'Package Rate',
            'OTC',
            'POP',
            'Name',
            'Contact',
            'NID',
            'Customer Info',
            'Area',
            'Cable Type',
            'C Date',
            'J Date',
            'Remarks',
            'Balance',
            'Email',
            'Mac'
        ];

        if (checkSettings('package_rate_in_client_search_excel') != 'enable') {
            $dataArray = array_diff($dataArray, ['Package Rate']);
        }
        return $dataArray;
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        $items = [];
        foreach ($this->data as $client) {

            if ($client->subpack) {
                // $speed =  'Sub Pack:' . $client->subpack->name . "\n" . 'Main Pack:' . $client->packages->package_name ?? '';
                $speed = 'Sub Pack:' . $client->subpack->name . "\n";
                if (auth()->user()->can('show-mother-package')) {
                    $speed .= 'Main Pack:' . $client->packages->package_name ?? '';
                }
                $rate = $client->subpack->rate ?? 0;
            } else {
                $speed =  'Pack:' . $client->packages->package_name ?? '';
                $rate = $client->packages->package_rate ?? 0;
            }

            $client_info  = $client->clientsinfo->flat_no . " " ?? '';
            $client_info .= $client->clientsinfo->building_name . " " ?? '';
            $client_info .= $client->clientsinfo->building_no . " " ?? '';
            $client_info .= $client->clientsinfo->road_name . " " ?? '';
            $client_info .= $client->clientsinfo->block_sector . " " ?? '';
            $client_info .= $client->clientsinfo->box . " " ?? '';
            $client_info .= $client->clientsinfo->olt_pon . " " ?? '';

            if (isset($client->customerAccount->dueAmount)) {
                $balance = $client->pop->bill_generate == "yes" ? "'" . (string)($client->customerAccount->dueAmount) . "'" : "'0";
            } else {
                $balance = "'0";
            }



            $items[] = [
                $client->id,
                $client->userid,
                $client->password,
                $client->customer_code ?? '',
                $client->clients_status,
                $client->expire_date ? date('Y-m-d', strtotime($client->expire_date)) : '',
                $client->billing_cycle,
                $speed,
                $rate,
                $client->clientsinfo->otc,
                $client->pop->popname,
                $client->clientsinfo->clients_name,
                $client->clientsinfo->contact_no ?? '',
                $client->clientsinfo->national_id ?? '',
                $client_info,
                $client->clientsinfo->area ?? '',
                $client->clientsinfo->cable_type ?? '',
                $client->created_at ? date('Y-m-d', strtotime($client->created_at)) : '',
                $client->clientsinfo->joinDate ? date('Y-m-d', strtotime($client->clientsinfo->joinDate)) : '',
                $client->clientsinfo->remarks ?? '',
                $balance,
                $client->clientsinfo->email ?? '',
                $client->mac ?? ''
            ];

            if (checkSettings('package_rate_in_client_search_excel') != 'enable') {
                $items = array_map(function ($item) {
                    return array_filter($item, function ($value, $key) {
                        return $key !== 8;
                    }, ARRAY_FILTER_USE_BOTH);
                }, $items);
            }
            $items = array_values($items);
        }
        return collect($items);
    }
}
