import { useEffect, useState } from 'react';
import { Col, Form, Row } from 'react-bootstrap';
import MapPorts from './MapPorts';
import { useDispatch } from 'react-redux';
import { AddDeviceToCluster } from '../../../../../../store/asyncMethods/deviceMethod';
import { setViewKey } from '../../../../../../store/reducers/currentClusterReducer';

const AddDevice = () => {
    const dispatch = useDispatch();
    const [device, setDevice] = useState({
        name: '',
        manufactures: '',
        model: '',
        serial_number: '',
        total_ports: '',
        remarks: '',
        ports: [],
    });

    const onChangeHandler = (e) => {
        setDevice({ ...device, [e.target.name]: e.target.value });
    };

    useEffect(() => {
        if (isNaN(device.total_ports)) return;

        setDevice((prev) => {
            const ports = [];
            for (let i = 0; i < device.total_ports; i++) {
                ports.push({
                    port_number: i + 1,
                    label: '',
                    type: '1g',
                    port_stream: 'outgoing',
                });
            }
            return { ...prev, ports };
        });
    }, [device.total_ports]);

    const onSubmitHandler = async (e) => {
        e.preventDefault();
        dispatch(
            AddDeviceToCluster(device, () => {
                dispatch(setViewKey('view'));
                setDevice({
                    name: '',
                    manufactures: '',
                    model: '',
                    serial_number: '',
                    total_ports: '',
                    remarks: '',
                    ports: [],
                });
            })
        );
    };

    return (
        <Form onSubmit={onSubmitHandler}>
            <Row>
                <Col lg={6}>
                    <Form.Control
                        placeholder='Name'
                        className='mt-2'
                        name='name'
                        onChange={onChangeHandler}
                        value={device.name}
                    />
                    <Form.Control
                        placeholder='Manufactures'
                        className='mt-2'
                        name='manufactures'
                        onChange={onChangeHandler}
                        value={device.manufactures}
                    />
                    <Form.Control
                        placeholder='Model'
                        className='mt-2'
                        name='model'
                        onChange={onChangeHandler}
                        value={device.model}
                    />
                    <Form.Control
                        placeholder='Serial Number'
                        className='mt-2'
                        name='serial_number'
                        onChange={onChangeHandler}
                        value={device.serial_number}
                    />
                    <Form.Group>
                        <Form.Control
                            type='number'
                            className='mt-2'
                            placeholder='Port Count'
                            name='total_ports'
                            onChange={onChangeHandler}
                            value={device.total_ports}
                        />
                    </Form.Group>
                    <Form.Control
                        as='textarea'
                        row={8}
                        className='mt-2'
                        placeholder='Remarks'
                        name='remarks'
                        onChange={onChangeHandler}
                        value={device.remarks}
                    />
                </Col>
            </Row>
            <hr />
            <MapPorts device={device} setDevice={setDevice} />
            <hr />
            <button className='btn btn-primary' type='submit'>
                Add Device
            </button>
        </Form>
    );
};

export default AddDevice;
