@extends('layout.app')


@section('content')
    <div class="row">
        <div class="col-md-8 m-auto">
            <div class="card">
                <div class="card-body">
                    <h2 class="text-center">Add Olt</h2>
                </div>
                <form action="{{ route('oltinfo.update', $oltinfo->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-11 m-auto">
                            <div class="form-group">
                                <label for="olt_address">Olt Address</label>
                                <input type="text" name="olt_address" class="form-control" id="olt_address"
                                    value="{{ $oltinfo->olt_address }}">
                            </div>
                            <div class="form-group">
                                <label for="community">Community</label>
                                <input type="text" name="community" class="form-control" id="community"
                                    value="{{ $oltinfo->community }}">
                            </div>
                            <div class="form-group">
                                <label for="olt_company">Olt Company</label>
                                <select name="olt_company" id="" class="form-control">
                                    <option value="">Select Olt Company</option>
                                    <option value="BDCom" {{ ($oltinfo->olt_company == 'BDCom') ? 'selected' : '' }}>BDCom</option>
                                    <option value="Vsol" {{ ($oltinfo->olt_company == 'Vsol') ? 'selected' : '' }}>Vsol</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="olt_type">Olt Type</label>
                                <select name="olt_type" id="" class="form-control">
                                    <option value="">Select Olt Type</option>
                                    <option value="Epon" {{ ($oltinfo->olt_type == 'Epon') ? 'selected' : '' }}>Epon</option>
                                    <option value="Gpon" {{ ($oltinfo->olt_type == 'Gpon') ? 'selected' : '' }}>Gpon</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="port">Port</label>
                                <input type="text" name="port" class="form-control" id="port" value="{{ $oltinfo->port }}">
                            </div>
                            <button class="btn btn-success mb-3" type="submit" style="float: right">Update Olt</button>
                        </div>
                    </div>


                </form>
            </div>
        </div>
    </div>
@endsection
