<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-light-primary elevation-2 ">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="user-panel  mb-2 pb-3 d-flex hidden " style="">
            <div class="image mt-2">
                <?php if(!empty(siteinfo())): ?>
                    <img class="mt-1" width="auto" height="50"
                        src="<?php echo e(asset('storage/company/' . siteinfo()->img_url ?? '')); ?>" alt=""
                        class="profile-image">
                <?php endif; ?>
            </div>
            <div class="info mt-2 companyTitleName">
                <?php if(!empty(siteinfo())): ?>
                    <a href="#" class="mt-2 d-block "
                        style=" font-size:x-large; text-transform: capitalize; letter-spacing: 1px;"><?php echo e(Str::limit(siteinfo()->name, 20) ?? ''); ?></a>
                <?php endif; ?>
            </div>
        </div>


        <!-- Sidebar Menu -->
        <nav class="mt-2" style="overflow-y: scroll; max-height:800px; overflow-x:hidden;">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                <?php if(Auth::user()->hasRole('Admin')): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('portal-invoice')): ?>
                        <li
                            class="nav-item <?php echo e(request()->routeIs(['portal-invoice*', 'portal-invoice/new']) ? 'menu-open' : ''); ?>">
                            <a href="<?php echo e(route('portal-invoice')); ?>" class="nav-link"><i
                                    class="fas fa-dollar-sign nav-icon"></i>
                                <p>Billing Fix Bill</p>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>



                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                    <li class="nav-item <?php echo e(request()->routeIs(['dashboard*', 'dashboard/new']) ? 'menu-open' : ''); ?>">
                        <a href="<?php echo e(route('dashboard')); ?>" class="nav-link"><i class="fas fa-border-all nav-icon"></i>
                            <p>Dashboard</p>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('network-manage')): ?>
                    <?php if(globalPermission('manage-map')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('map')); ?>" class="nav-link"><i class="fas fa-border-all nav-icon"></i>
                                <p>Network Map</p>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(checkSettings('Bank') == 'enable' && Auth::user()->can('bank')): ?>
                    <?php echo $__env->make('layout.leftsidebar.bank', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification-setting')): ?>
                    <?php if(checkSettings('notification') == 'enable'): ?>
                        <li class="nav-item <?php echo e(request()->routeIs(['notification*']) ? 'menu-open' : ''); ?>">
                            <a href="#" class="nav-link">
                                <i class="fas fa-bell nav-icon"></i>
                                <p>
                                    Notifications
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="#"  class="nav-link ">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Notification Settings</p>
                                    </a>
                                </li>
                            </ul>

                        </li>
                    <?php endif; ?>
                <?php endif; ?>



                <?php echo $__env->make('layout.leftsidebar.sms_setting', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('layout.leftsidebar.email_setting', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php if(auth()->check() && auth()->user()->hasAnyRole('Admin|Billing Man')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('view_user_account_history', auth()->user()->id)); ?>"
                            class="nav-link <?php echo e(request()->routeIs(['view_user_account_history']) ? 'open' : ''); ?>"><i
                                class="fas fa-file-invoice nav-icon"></i>
                            <p>Accounts History</p>
                        </a>
                    </li>
                <?php endif; ?>




                <?php echo $__env->make('layout.leftsidebar.settings_section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                    <?php echo $__env->make('layout.leftsidebar.customer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php if(checksettings('CRM') == 'enable'): ?>
                    <?php echo $__env->make('layout.leftsidebar.crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer-support')): ?>
                    <?php echo $__env->make('layout.leftsidebar.support', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('money-receipt-entry')): ?>
                    <?php echo $__env->make('layout.leftsidebar.account', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('specific_management_services')): ?>
                    <?php echo $__env->make('layout.leftsidebar.report', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>



                <?php echo $__env->make('layout.leftsidebar.store', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php if(checkSettings('Bandwidth-section') == 'enable'): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bandwidth-buy')): ?>
                        <li
                            class="nav-item <?php echo e(request()->routeIs(['band-provider.*', 'band-service.*', 'band-purchase.*', 'bandwidthReport']) ? 'menu-open' : ''); ?>">
                            <a href="#" class="nav-link">
                                <i class="fas fa-bell nav-icon"></i>
                                <p>
                                    Bandwidth Buy
                                    <i class="fas fa-angle-left right"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">

                                <li class="nav-item">
                                    <a href="<?php echo e(route('band-provider.index')); ?>"
                                        class="nav-link <?php echo e(request()->routeIs(['band-provider.index']) ? 'active' : ''); ?>">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Provider</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('band-service.index')); ?>"
                                        class="nav-link <?php echo e(request()->routeIs(['band-service.index']) ? 'active' : ''); ?>">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Service</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('band-purchase.index')); ?>"
                                        class="nav-link <?php echo e(request()->routeIs(['band-purchase.index']) ? 'active' : ''); ?>">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Purchase Bill</p>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('bandwidthReport')); ?>"
                                        class="nav-link <?php echo e(request()->routeIs(['bandwidthReport']) ? 'active' : ''); ?>">
                                        <i class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                                        <p>Purchase Report</p>
                                    </a>
                                </li>

                            </ul>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('bandwidth-sale')): ?>
                        <?php echo $__env->make('layout.leftsidebar.bwsale', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(checkSettings('payroll') == 'enable' && Auth::user()->can('payroll')): ?>
                    <?php echo $__env->make('layout.leftsidebar.payroll', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php echo $__env->make('layout.leftsidebar.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php if(checkSettings('help') == 'enable'): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('help.index')); ?>" class="nav-link">
                            <i class="fa fa-question-circle nav-icon" aria-hidden="true"></i>
                            <p>Help</p>
                        </a>
                    </li>
                <?php endif; ?>

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>


<style>
    .sidebar nav::-webkit-scrollbar {
        width: 5px;
    }


    .sidebar nav::-webkit-scrollbar-track {
        background: #f1f1f1;
    }


    .sidebar nav::-webkit-scrollbar-thumb {
        background: #888;
    }


    .sidebar nav::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
</style>
<?php /**PATH /var/www/html/kn24/radius-circle/resources/views/layout/leftaside_lte.blade.php ENDPATH**/ ?>