<?php

namespace App\Classes;

use App\Http\Controllers\OtcPaymentLogController;
use App\Models\Client;
use App\Models\Clientsinfo;
use Illuminate\Support\Facades\DB;


class BillgenerateUpdate
{


    public function update($client_id)
    {
        // dd($client_id);
        $client = Client::with('generatedBill','paymentBill','customerAccountAdjustment')->withTrashed()->find($client_id);

        $tatal_paid_amount = $client->paymentBill->sum('paid_amount') + $client->paymentBill->sum('discount_amount') - $client->customerAccountAdjustment->sum('amount') ?? 0;
        foreach($client->generatedBill as $bill){

           DB::beginTransaction();
           try{
                if($tatal_paid_amount >= $bill->bill_amount){
                    $bill->paid_amount = $bill->bill_amount;
                    $bill->save();
                    $tatal_paid_amount = $tatal_paid_amount - $bill->bill_amount;

                }else if ($tatal_paid_amount < $bill->bill_amount && $tatal_paid_amount > 0){
                    $bill->paid_amount = $tatal_paid_amount;
                    $bill->save();
                    $tatal_paid_amount = $tatal_paid_amount - $tatal_paid_amount;
                }else{
                    $bill->paid_amount = 0;
                    $bill->save();

                }
                // dd($bill);
                if(checkSettings('otc_payment_with_generale_payment') == 'enable'){
                    // dd('comes');
                    if($bill->billing_type == 'otc'){

                       $client_info = Clientsinfo::where('client_id',$client->id)->first();
                       $previous_otc = $client_info->otc;
                       $previous_otc_due = $client_info->otc_due;
                       $client_info->otc_due = $client_info->otc - $bill->paid_amount;
                       $client_info->save();

                       $current_otc_due = $client_info->otc_due;
                        $otc_payment = 0;

                       if($previous_otc > 0){
                           $otc_payment = $previous_otc_due - $current_otc_due;
                       }

                       if($otc_payment > 0){
                          OtcPaymentLogController::otcPaymentLog($client->id,$otc_payment,$bill->id);
                       }

                    }
                }

                DB::commit();
           }catch(\Exception $e){
                dd($e);
               DB::rollback();
               return false;
           }

        }

        // dd($client->generatedBill);
    }


    public function updateAll($clients)
    {
        foreach($clients as $client){
            echo 'start process for client'.$client->id;
            DB::beginTransaction();
            try{

                $tatal_paid_amount = $client->paymentBill->sum('paid_amount')+ $client->paymentBill->sum('discount_amount') - $client->customerAccountAdjustment->sum('amount') ?? 0;
                foreach($client->generatedBill as $bill){
                    if($tatal_paid_amount >= $bill->bill_amount){
                        $bill->paid_amount = $bill->bill_amount;
                        $bill->save();
                        $tatal_paid_amount = $tatal_paid_amount - $bill->bill_amount;

                    }else if ($tatal_paid_amount < $bill->bill_amount && $tatal_paid_amount > 0){
                        $bill->paid_amount = $tatal_paid_amount;
                        $bill->save();
                        $tatal_paid_amount = $tatal_paid_amount - $tatal_paid_amount;
                    }else{
                        $bill->paid_amount = 0;
                        $bill->save();
                    }
                }
                DB::commit();
            }catch(\Exception $e){

                return redirect()->back();
            }
            echo '<br>';
            echo 'Process complete';
            echo '<br>';


        }
    }
}

