<?php

namespace App\Classes\SMS;

use App\Jobs\ResellerSendSms;


class ExpireCustomerNotifySms
{


  public function sendOtherReseller($client,$gatway,$reseller_name,$reseller_cell,$message,$reseller_id){


        $message = str_replace(
            [
                '{c_id}',
                '{c_name}',
                '{c_username}',
                '{c_password}',
                '{package_name}',
                '{package_price}',
                '{c_expire_date}',
                '{reseller_name}',
                '{reseller_mobile}'
            ],
            [
                $client->id,
                $client->clientsinfo->clients_name ?? '',
                $client->userid,
                $client->password,
                $client->packages->package_name,
                $client->packages->package_rate,
                $client->expire_date,
                $reseller_name,
                $reseller_cell
            ],
            $message
        );

        $contact = $client->clientsinfo->contact_no;
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "Expire Customer",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
  }

  public function otherResellerCustomerSendSmsBeforeExpire($client,$gatway,$reseller_name,$reseller_cell,$message,$reseller_id){

            $message = str_replace(
                [
                    '{c_id}',
                    '{c_username}',
                    '{c_name}',
                    '{c_expire_date}',
                    '{package_price}',
                    '{reseller_name}',
                    '{reseller_mobile}'
                ],
                [
                    $client->id,
                    $client->userid,
                    $client->clientsinfo->clients_name ?? '',
                    $client->expire_date,
                    $client->packages->package_rate,
                    $reseller_name,
                    $reseller_cell
                ],
                $message
            );

            $contact = $client->clientsinfo->contact_no;
            $data = [
                'reseller_id' => $reseller_id,
                'contact' => $contact,
                'message' => $message,
                'type' => "Reminder",
                'api' => $gatway

            ];
            ResellerSendSms::dispatch($data);
  }
}
