<?php

namespace App\Classes\SMS;

use App\Jobs\ExpireCustomerNotification;
use App\Models\CustomerAccount;
use App\Models\CustomerBillingCycleInfo;
use App\Models\CustomerPackageChangeInfo;
use App\Models\Packages;
use Carbon\Carbon;
use Illuminate\Support\Carbon as SupportCarbon;

class PaymentSms
{

  public function getSmsBody($type)
  {

    if ($type == 1) {
      $body = getSmsMessage()->where('tamplate_name', 'new_customer_payment_sms')->first()->tamplate_body;
    } elseif ($type == 2) {
      $body = getSmsMessage()->where('tamplate_name', 'otc_payment_sms')->first()->tamplate_body;
    } elseif ($type == 3) {
      $body = getSmsMessage()->where('tamplate_name', 'billing_cycle_change_payment_sms')->first()->tamplate_body;
    } elseif ($type == 4) {
      $body = getSmsMessage()->where('tamplate_name', 'package_change_payment_sms')->first()->tamplate_body;
    } elseif ($type == 5) {
      $body = getSmsMessage()->where('tamplate_name', 'bill_payment')->first()->tamplate_body;
    } elseif ($type == 6) {
      $body = getSmsMessage()->where('tamplate_name', 'advanced_payment_sms')->first()->tamplate_body;
    }
    return $body;
  }



  public function billPaymentSms($client, $amount, $receipt_id, $payment_id, $type = null, $discount = null, $totalDue = 0, $payment_description = '', $payment_type = 5)
  {

    if ($client->pop->bill_generate == 'yes') {

      if (checkSettings('bill-payment-sms') == 'enable') {
        if (getBillingType() == 'day_to_day'){
            $clientAccount = CustomerAccount::where('client_id', $client->id)->first();
            $client_package = Packages::find($client->package_id);
            if(($clientAccount->dueAmount < 0) && (abs($clientAccount->dueAmount) >= $client_package->package_rate)){
                // dd(abs($clientAccount->dueAmount) <= $client_package->package_rate, abs($clientAccount->dueAmount), $client_package->package_rate);
                $expire_date =  Carbon::parse($client->expire_date)->addDay(30)->format('d-m-Y');
            }else{
                $expire_date =  Carbon::parse($client->expire_date)->format('d-m-Y');
            }
        }else{
            $expire_date =  Carbon::parse($client->expire_date)->format('d-m-Y');
        }

        if($payment_type > 6){
            $payment_type = 5;
        }
        $message = $this->getSmsBody($payment_type);
        if($payment_type != 5){
            $data = json_decode($this->getSmsBody($payment_type));
            if($data->sendsms == 'Yes'){
                $message = $data->sms_body;
            }else{
                $message = $this->getSmsBody(5);
            }
            if($payment_type == 4){
                $package_change_info = CustomerPackageChangeInfo::where('client_id', $client->id)->orderBy('id', 'DESC')->first();
            }
            if($payment_type == 3){
                $billing_change_info = CustomerBillingCycleInfo::where('client_id', $client->id)->orderBy('id', 'DESC')->first();
            }
        }
          $companyName = siteinfo()->name;
          $companyNumber = siteinfo()->mobile;

          $message = str_replace(
            [
              '{c_id}',
              '{c_name}',
              '{c_username}',
              '{c_expire_date}',
              '{PaymentAmount}',
              '{PaymentDiscount}',
              '{PaymentMethod}',
              '{TotalDue}',
              '{MoneyreciptNo}',
              '{TrxId}',
              '{company_name}',
              '{company_cell}',
              '{payment_date}',
              '{payment_description}',
              '{old_package_name}',
              '{new_package_name}',
              '{old_billing_cycle}',
              '{new_billing_cycle}',
            ],
            [
              $client->id,
              $client->clientsinfo->clients_name,
              $client->userid,
              $expire_date,
              $amount,
              $discount,
              $type,
              $totalDue,
              $receipt_id,
              $payment_id,
              $companyName,
              $companyNumber,
              Carbon::now()->format('d-m-Y'),
              $payment_description,
              isset($package_change_info->previous_package_name) ? $package_change_info->previous_package_name ?? " " :  '',
              isset($package_change_info->new_package_name) ? $package_change_info->new_package_name ?? " " :  '',
              isset($billing_change_info->previous_billing_cycle) ? $billing_change_info->previous_billing_cycle ?? " " :  '',
              isset($billing_change_info->current_billing_cycle) ? $billing_change_info->current_billing_cycle ?? " " :  '',
            ],
            $message
          );


          $contact = $client->clientsinfo->contact_no;

          $data = [
            'contact_no' => $contact,
            'message'    => $message,
            'type'        => 'payment'
          ];

          if(!empty($contact)){
            ExpireCustomerNotification::dispatch($data);
          }


      }
    }
  }
}
