<?php

namespace App\Classes\SMS;

use App\Jobs\SendSmsJob;
use App\Models\Client;
use App\Models\CompanyInformation;
use Carbon\Carbon;

class PopExceptionDeletSms
{
    public function sendPopExceptionDeletSms($client_userId)
    {


        $company_info = CompanyInformation::latest()->first();
        $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'pop_expair_exception_delete')->first()->tamplate_body,true);
        $sms_send = $sms_setting["sendsms"];
        $message = $sms_setting["sms_body"];
        $client = Client::with('clientsinfo','customerAccount','pop')->where('userid',$client_userId)->first();
        if($sms_send == "Yes" && $client->pop->bill_generate == 'yes'){
            $message = str_replace(
                [
                    '{c_id}',
                    '{c_username}',
                    '{c_name}',
                    '{c_deadline}',
                    '{TotalDue}',
                    '{company_name}',
                    '{company_cell}',
                ],
                [
                    $client->id,
                    $client->userid ,
                    $client->clientsinfo->clients_name,
                    $client->expire_date,
                    $client->customerAccount->dueAmount ?? 0,
                    $company_info->name,
                    $company_info->mobile,
                ],
                $message
            );

            $data = [
                'message' => $message,
                'contact_no' => $client->clientsinfo->contact_no,
                'type' => 'pop_expair_exception_delete'
            ];

            SendSmsJob::dispatch($data);
        }
    }
}
