<?php

namespace App\Classes\SMS;

use App\Jobs\SendSmsJob;
use App\Models\Token;
use App\Models\TokenNote;

class TokenSms
{
    public function createSms($token_id)
    {
        // dd("TokenSms");
        $token = Token::with('clients.clientsinfo','Code','category')->where('id',$token_id)->first();
        $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'token_create_customer_sms')->first()->tamplate_body,true);
        $sms_send = $sms_setting["sendsms"];
        $message = $sms_setting["sms_body"];
        $contact_customer = $token->reporterContact;
        $companyName = siteinfo()->name;
        $companyNumber = siteinfo()->mobile;

        // dd($token->Code);

        $message = str_replace(
            [
            '{c_id}',
            '{c_username}',
            '{c_name}',
            '{token_no}',
            '{token_category}',
            '{token_code}',
            '{billing_no}',
            '{technical/support_no}',
            '{company_name}',
            '{company_cell}',
            ],
            [
                $token->clients->id,
                $token->clients->userid,
                $token->clients->clientsinfo->clients_name,
                $token->token,
                $token->category->name,
                $token->Code->tokenCode,
                siteinfo()->billing_no,
                siteinfo()->technical_or_support_no,
                $companyName,
                $companyNumber,
            ],
            $message
        );
        // dd($message);
        if ($sms_send == "Yes") {
            $data = [
                'message' => $message,
                'contact_no' => $contact_customer,
                'type' => 'token_create',
            ];
            SendSmsJob::dispatch($data);
        }
    }

    public function assignTokenSms($token_id)
    {


            $token = Token::with('clients.clientsinfo','category','employees','Code')->find($token_id);
            $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'token_assign_customer_sms')->first()->tamplate_body,true);
            $sms_send = $sms_setting["sendsms"];
            $message = $sms_setting["sms_body"];

            $companyName = siteinfo()->name;
            $companyNumber = siteinfo()->mobile;


            $message = str_replace(
                [
                '{c_id}',
                '{c_username}',
                '{c_name}',
                '{employee_name}',
                '{employee_number}',
                '{token_no}',
                '{token_category}',
                '{token_code}',
                '{billing_no}',
                '{technical/support_no}',
                '{company_name}',
                '{company_cell}',
                ],
                [
                    $token->clients->id,
                    $token->clients->userid,
                    $token->clients->clientsinfo->clients_name,
                    $token->employees->name,
                    $token->employees->mobile_office,
                    $token->token,
                    $token->category->name,
                    $token->Code->tokenCode,
                    siteinfo()->billing_no,
                    siteinfo()->technical_or_support_no,
                    $companyName,
                    $companyNumber,
                ],
                $message
            );


            // send sms for customer
            if($sms_send == "Yes"){
                SendSmsJob::dispatch([
                    'message' => $message,
                    'contact_no' => $token->reporterContact,
                    'type' => 'token_assign_customer'
                ]);
            }


            $sms_setting_employee = json_decode(getSmsMessage()->where('tamplate_name', 'token_assign_employee_sms')->first()->tamplate_body,true);
            $sms_send_employee = $sms_setting_employee["sendsms"];
            $message_employee = $sms_setting_employee["sms_body"];

            $message_employee = str_replace(
                [
                '{c_id}',
                '{c_username}',
                '{c_name}',
                '{employee_name}',
                '{reporter_contact_no}',
                '{token_no}',
                '{token_category}',
                '{token_code}',
                '{billing_no}',
                '{technical/support_no}',
                '{company_name}',
                '{company_cell}',
                ],
                [
                    $token->clients->id,
                    $token->clients->userid,
                    $token->clients->clientsinfo->clients_name,
                    $token->employees->name,
                    $token->reporterContact,
                    $token->token,
                    $token->category->name,
                    $token->Code->tokenCode,
                    siteinfo()->billing_no,
                    siteinfo()->technical_or_support_no,
                    $companyName,
                    $companyNumber,
                ],
                $message_employee
            );

            if ($token->employees->mobile_office && $sms_send_employee == "Yes") {

                SendSmsJob::dispatch([
                    'message' => $message_employee,
                    'contact_no' => $token->employees->mobile_office,
                    'type' => 'token_assign_employee'
                ]);
            }

    }

    public function closeTokenSms($token)
    {
        // $token = Token::with('clients.clientsinfo','category','employees','Code')->find($token_id);
            // $message = "আপনার সমস্যাটি সমাধান হয়েছে। আমরা আপনার টোকেন আইডি " . $token->token . " : " . $token->Code->tokenCode . " মুছে ফেলেছি। যদি এখনো সমস্যার সমাধান না হয় তাহলে " . siteinfo()->mobile . " এই নম্বর এ অভিযোগ করুন।আমাদের সাথে থাকার জন্য ধন্যবাদ।";
            $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'token_close_customer_sms')->first()->tamplate_body,true);
            $sms_send = $sms_setting["sendsms"];
            $message = $sms_setting["sms_body"];

            $companyName = siteinfo()->name;
            $companyNumber = siteinfo()->mobile;


            $message = str_replace(
                [
                '{c_id}',
                '{c_username}',
                '{c_name}',
                '{employee_name}',
                '{employee_number}',
                '{token_no}',
                '{token_category}',
                '{token_code}',
                '{billing_no}',
                '{technical/support_no}',
                '{company_name}',
                '{company_cell}',
                ],
                [
                    $token->clients->id,
                    $token->clients->userid,
                    $token->clients->clientsinfo->clients_name,
                    $token->employees->name,
                    $token->employees->mobile_office,
                    $token->token,
                    $token->category->name,
                    $token->Code->tokenCode,
                    siteinfo()->billing_no,
                    siteinfo()->technical_or_support_no,
                    $companyName,
                    $companyNumber,
                ],
                $message
            );


            // send sms for customer
            if($sms_send == "Yes"){
                SendSmsJob::dispatch([
                    'message' => $message,
                    'contact_no' => $token->reporterContact,
                    'type' => 'token_close'
                ]);
            }

    }

    public function TokenNoteCustomerSms($note_id)
    {

            $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'token_note_customer_sms')->first()->tamplate_body,true);
            $sms_send = $sms_setting["sendsms"];
            $message = $sms_setting["sms_body"];

            $companyName = siteinfo()->name;
            $companyNumber = siteinfo()->mobile;

            $note = TokenNote::with('token')->find($note_id);


            $message = str_replace(
                [
                '{note}',
                '{token_no}',
                '{technical/support_no}',
                '{company_name}',
                '{company_cell}',
                ],
                [
                    $note->note,
                    $note->token->token,
                    siteinfo()->technical_or_support_no,
                    $companyName,
                    $companyNumber,
                ],
                $message
            );


            // send sms for customer
            if($sms_send == "Yes"){
                SendSmsJob::dispatch([
                    'message' => $message,
                    'contact_no' => $note->token->reporterContact,
                    'type' => 'token_note_customer'
                ]);
            }

    }

    public function reAssignTokenSMS($token_id)
    {
        $token = Token::with('clients.clientsinfo','category','employees','Code')->find($token_id);

        $companyName = siteinfo()->name;
        $companyNumber = siteinfo()->mobile;

        $sms_setting_employee = json_decode(getSmsMessage()->where('tamplate_name', 'token_reassign_employee_sms')->first()->tamplate_body,true);
        $sms_send_employee = $sms_setting_employee["sendsms"];
        $message_employee = $sms_setting_employee["sms_body"];

        // dd($sms_send_employee);
        $message_employee = str_replace(
            [
            '{c_id}',
            '{c_username}',
            '{c_name}',
            '{employee_name}',
            '{reporter_contact_no}',
            '{token_no}',
            '{token_category}',
            '{token_code}',
            '{billing_no}',
            '{technical/support_no}',
            '{company_name}',
            '{company_cell}',
            ],
            [
                $token->clients->id,
                $token->clients->userid,
                $token->clients->clientsinfo->clients_name,
                $token->employees->name,
                $token->reporterContact,
                $token->token,
                $token->category->name,
                $token->Code->tokenCode,
                siteinfo()->billing_no,
                siteinfo()->technical_or_support_no,
                $companyName,
                $companyNumber,
            ],
            $message_employee
        );

        if ($token->employees->mobile_office && $sms_send_employee == "Yes") {
            SendSmsJob::dispatch([
                'message' => $message_employee,
                'contact_no' => $token->employees->mobile_office,
                'type' => 'token_re_assign_employee'
            ]);
        }
    }
}

