<?php

namespace App\Classes\SMS;

use App\Http\Controllers\CompanyInfoController;
use App\Jobs\ResellerSendSms;
use App\Jobs\SendSmsJob;

class WelcomeSms
{
  public function send($client)
  {
      if ($client->pop->bill_generate == 'yes') {

        if (checkSettings('new-user-create-sms') == 'enable') {

              $message = getSmsMessage()->where('tamplate_name', 'welcome')->first()->tamplate_body;
              $companyName = siteinfo()->name;
              $companyNumber = siteinfo()->mobile;
              $link = CompanyInfoController::baseUrl();
              $message = str_replace(
                  [
                      '{c_id}',
                      '{c_name}',
                      '{c_username}',
                      '{c_password}',
                      '{c_package}',
                      '{c_deadline}',
                      '{company_name}',
                      '{company_cell}',
                      '{payment_url}'
                  ],
                  [
                      $client->id,
                      $client->clientsinfo->clients_name ?? '',
                      $client->userid,
                      $client->password,
                      $client->packages->package_name,
                      $client->expire_date,
                      $companyName,
                      $companyNumber,
                      $link.$client->slug
                  ],
                  $message
              );

              $contact = $client->clientsinfo->contact_no;
              $data = [
                  'contact_no' => $contact,
                  'message' => $message,
                  'type'    => 'New Registration'
              ];
              SendSmsJob::dispatch($data);
          }
      }
  }

  public function sendOtherReseller($client,$gatway,$reseller_name,$reseller_cell,$message,$reseller_id){


        $message = str_replace(
            [
                '{c_id}',
                '{c_name}',
                '{c_username}',
                '{c_password}',
                '{package_name}',
                '{package_price}',
                '{c_expire_date}',
                '{reseller_name}',
                '{reseller_mobile}'
            ],
            [
                $client->id,
                $client->clientsinfo->clients_name ?? '',
                $client->userid,
                $client->password,
                $client->packages->package_name,
                $client->packages->package_rate,
                $client->expire_date,
                $reseller_name,
                $reseller_cell
            ],
            $message
        );

        $contact = $client->clientsinfo->contact_no;
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "New Registration",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
  }
}
