<?php

namespace App\Classes;

use App\Models\SmsApi;
use App\Models\SmsLog;
use Illuminate\Support\Facades\Http;

class SmsDeliveryCheck
{
  public function status()
  {

    $this->changeStatusForFaild();
    $lists = SmsLog::where('status','processing')->get();

    foreach ($lists as $list) {
      $check = $this->check($list);
      if ($check == 'delivered') {
        $list->status = 'delivered';
        $list->save();
      }
    }
  }

  public function check($id)
  {
    $v = json_decode($id->delivery_message)->dlrRef;
    
    $link = 'https://sms.solutionsclan.com/api/sms/dlr?dlrRef='.$v;
    $response = Http::get($link); 

    echo $response;
    dd();


  }

  public function changeStatusForFaild()
  {
    $list = SmsLog::where('delivery_message','like','%You can send sms to only one number at a time for now%')
                    ->where('status','processing')
                    // ->get();
                    ->update(['status' => 'faild']);    
  }
}
