<?php

namespace App\Console\Commands;

use App\Classes\BillgenerateUpdate;
use App\Models\Client;
use App\Models\Pop;
use App\Models\Reseller;
use Illuminate\Console\Command;
use Illuminate\Database\Capsule\Manager;

class AllCustomerBillGenerateUpdateCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'customer:billgenerateupdate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $ownManager = Reseller::where('reseller_type', 'own')->pluck('id')->toArray();

        $pop = Pop::whereIn('reseller_id',$ownManager)->pluck('id')->toArray();

        $clients = Client::whereIn('pop_id',$pop)->get();

        foreach($clients as $client){
            echo $client->id."\n";
            try{
                (new BillgenerateUpdate)->update($client->id);
            }catch(\Exception $e){
                echo $e->getMessage();
            }

        }

    }
}
