<?php

namespace App\Console\Commands;

use App\Jobs\BandwidthStoreJob;
use App\Models\Client;
use App\Models\Pop;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class ClientBandwidthStore extends Command
{
    protected $signature = 'store:bandwidth';

    protected $description = 'Store client used bandwidth';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        // Log::info("log -store:bandwidth");

        $this->info("start to store clients used bandwidth \n");

        if (!checkAPI()) {

            if (checkSettings('only_local_bandwidth_check') == 'enable') {

                $pops_id = Pop::where('bill_generate', 'yes')->pluck('id')->toArray();
                Client::where('clients_status', '!=', 'deactive')->where('clients_status', '!=', 'close')
                    // ->where('bandwidth_limit', '!=', 0)
                    ->whereIn('pop_id', $pops_id)
                    ->select('id', 'userid', 'expire_date', 'bandwidth_limit')
                    ->chunk(100, function ($clients) {
                        BandwidthStoreJob::dispatch($clients);
                    });

                $this->info("End to store only local clients used bandwidth");
            } else {

                Client::where('clients_status', '!=', 'deactive')->where('clients_status', '!=', 'close')
                    // ->where('bandwidth_limit', '!=', 0)
                    ->select('id', 'userid', 'expire_date', 'bandwidth_limit')
                    ->chunk(100, function ($clients) {
                        BandwidthStoreJob::dispatch($clients);
                    });

                $this->info("End to store all clients used bandwidth");
            }
        } else {

            $this->info("Sorry its not possible to store clients used bandwidth \n");
        }
    }
}
