<?php

namespace App\Console\Commands;

use App\Classes\SMS\ExpireCustomerNotifySms;
use App\Http\Controllers\CompanyInfoController;
use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Client;
use Illuminate\Console\Command;
use App\Jobs\ExpireCustomerNotification;
use App\Models\ResellerSmsGetway;
use App\Models\ResellerSmsLog;
use App\Models\SmsLog;
use App\Models\SmsPaymentReminder;
use Illuminate\Support\Facades\Log;

class ExpireSmsSendCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expire:notification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This Will send sms to expire customer';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */

    public function getMessage($client, $type, $sms)
    {
        $link = CompanyInfoController::baseUrl();
        if ($client->customerAccount && $client->customerAccount->dueAmount > 0) {
            $dueAmount = $client->customerAccount->dueAmount;
        } else {
            $dueAmount = 0;
        }


        if (getBillingType() == 'day_to_day') {
            $check_due = isset($client->customerAccount) ? $client->customerAccount->dueAmount : 0;
            $dueAmount = ($client->packages->package_rate ?? 0)  + $check_due - ($client->parmanent_discount ?? 0);

        }

        if ($type == 'frist_sendsms') {
            $message = $sms->frist_sms_body;

            $message = str_replace(
                [
                    '{c_id}',
                    '{c_username}',
                    '{c_name}',
                    '{c_password}',
                    '{c_deadline}',
                    '{MonthlyBill}',
                    '{TotalDue}',
                    '{company_name}',
                    '{company_cell}',
                    '{payment_url}'
                ],
                [
                    $client->id,
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    $client->password,
                    Carbon::parse($client->expire_date)->format('d-M-Y'),
                    $client->packages->package_rate ?? 0,
                    $dueAmount,
                    siteinfo()->name,
                    siteinfo()->mobile,
                    $link.$client->slug
                ],
                $message
            );
        }

        if ($type == 'second_sendsms') {
            exit;
            $message = $sms->second_sms_body;

            $message = str_replace(
                [
                    '{c_id}',
                    '{c_username}',
                    '{c_name}',
                    '{c_deadline}',
                    '{MonthlyBill}',
                    '{TotalDue}',
                    '{company_name}',
                    '{company_cell}'
                ],
                [
                    $client->id,
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    Carbon::parse($client->expire_date)->format('d-M-Y'),
                    $client->packages->package_rate ?? 0,
                    $dueAmount,
                    siteinfo()->name,
                    siteinfo()->mobile
                ],
                $message
            );
        }



        return $message;
    }

    public function log($step, $expire_date, $client_list)
    {
    }



    public function handle()
    {
        // Log::info("log -expire:notification");

        $pops = Pop::where('bill_generate', 'yes')->where('sms_send', 'yes')->pluck('id');


        $sms = json_decode(getSmsMessage()->where('tamplate_name', 'bill_reminder')->first()->tamplate_body);

        $clients = Client::with('customerAccount', 'packages:id,package_rate', 'clientsinfo:id,client_id,contact_no,clients_name')->where(function ($q) {
            $q->where('clients_status', 'active')
                ->orWhere('clients_status', 'expired')
                ->orWhere('clients_status', 'disable');
        })->whereHas('customerAccount', function ($q) {
            if(getBillingType() != 'day_to_day'){
                $q->where('dueAmount', '>', 0);
            }
        })->whereIn('pop_id', $pops);


        if ($sms->frist_sendsms == 'Yes') {

            if (today()->format('d') == '01') {

                SmsPaymentReminder::where('expire_date', today()->format('Y-m-d'))->delete();

                $clients = $clients->where('expire_date', today())
                    ->select('id', 'expire_date', 'clients_status', 'pop_id', 'userid','password', 'slug', 'package_id')->get();
            } else {
                $clients = $clients->where('expire_date', today()->addDay($sms->first_reminder_day))
                    ->select('id', 'expire_date', 'clients_status', 'pop_id', 'userid', 'password', 'slug', 'package_id')->get();
            }


            if ($clients->count() > 0) {

                if (SmsPaymentReminder::where('expire_date', $clients->first()->expire_date)->where('step', 'first')->count() < 1) {

                    $client_ids = $clients->pluck('userid')->toJson();

                    SmsPaymentReminder::create([
                        'step' => 'first',
                        'expire_date' => $clients->first()->expire_date,
                        'user_list' => $client_ids
                    ]);


                    foreach ($clients as $client) {

                        $data = [
                            'message' => $this->getMessage($client, 'frist_sendsms', $sms),
                            'contact_no' => $client->clientsinfo->contact_no,
                            'type' => 'reminder'
                        ];
                        if (getBillingType() == 'day_to_day') {
                            $check_due = isset($client->customerAccount) ? $client->customerAccount->dueAmount : 0;
                            $dueAmount = ($client->packages->package_rate ?? 0)  + $check_due - ($client->parmanent_discount ?? 0);

                            if($dueAmount > 0){
                                ExpireCustomerNotification::dispatch($data);
                            }
                        }else{
                            ExpireCustomerNotification::dispatch($data);
                        }

                    }
                }
            }
        }

        $other_resellers_pops = Pop::where('bill_generate', 'no')->get();

        foreach ($other_resellers_pops as $pop) {
            $reseller_sms_getway = ResellerSmsGetway::with('reseller')->where('reseller_id', $pop->reseller_id)->first();
            if($reseller_sms_getway){
                $reminder_customer_sms = collect(json_decode($reseller_sms_getway->sms_formate))->where('sms_type','other_reseller_customer_reminder')->first();
                if($reminder_customer_sms->send_sms == "Yes"){
                    $notify_clients = Client::with('clientsinfo')->where('expire_date', today()->addDay($reminder_customer_sms->days_before))->where('pop_id', $pop->id)->get();
                    foreach($notify_clients as $item){
                        (new ExpireCustomerNotifySms)->otherResellerCustomerSendSmsBeforeExpire($item,$reseller_sms_getway->sms_gateway,$reseller_sms_getway->reseller->name,
                                                            $reseller_sms_getway->reseller->contact,$reminder_customer_sms->sms_body,$reseller_sms_getway->reseller->id);
                    }
                }
            }

        }
    }
}
