<?php

namespace App\Console\Commands;

use App\Classes\MikrotikService\MikrotikStaticIP;
use App\Classes\MikrotikService\SyncWithMk;
use App\Models\Client;
use App\Models\Nas;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class StaticBind extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'static:bind';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Bind static ip with active client.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Log::info("log -static:bind");

        $mikrotik =  Nas::all();

        $allArp = [];
        foreach ($mikrotik as $mikrotik) {
            $mk = new MikrotikStaticIP($mikrotik->nasname, $mikrotik->mikrotick_user, $mikrotik->mikrotick_user_password, $mikrotik->mikrotick_port);
            $allArp += $mk->getArpList();
        }


        foreach ($allArp as $arp) {
            $client = Client::where("ip_address", $arp["address"])->first();
            if ($arp["dynamic"] == "true" && $client) {
                $client->update(["mac" => $arp["mac-address"]]);
                (new SyncWithMk())->syncSingleClient($client->id);
            }
        }

        return 0;
    }
}
