<?php

namespace App\Console\Commands;

use App\Models\Client;
use Illuminate\Console\Command;
use App\Http\Controllers\BillGenerateController;
use Illuminate\Support\Facades\Log;

class generateBillFixForNewUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bill:generateBillFixForNewUser';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'generateBillFixForNewUser';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Log::info("log -bill:generateBillFixForNewUser");

        $clients = Client::with(['generatedBill' => function ($query) {
            $query->where('billing_type', 'monthly');
        }])
            ->whereBetween('created_at', [today()->firstOfMonth(), today()->lastOfMonth()])
            ->whereHas('generatedBill', function ($query) {
                $query->whereIn('billing_type', ['new'])
                    ->where('due_date', '>', today()->lastOfMonth());
            })
            ->where('expire_date', '>', today()->lastOfMonth())
            ->select('id', 'expire_date', 'userid', 'created_at')
            ->get();


            // dd($clients->count());


        foreach ($clients as $client) {
            // echo $client->id;
            // echo '<br>';


            if ($client->generatedBill->count() > 0) {
                echo $client->id;
                echo '<br>';
                (new \App\Http\Controllers\BillGenerateController)->monthlyBillFix(request(), $client->generatedBill->first()->id);
            }


            // echo 'process end';
            // echo '<br>';
        }
    }
}
