<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use App\Models\ExpenseHead;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Services\FundTransferService;
use App\Models\Income;
use App\Models\IncomeHead;

class AccountStatementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('accounts.accountStatement.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function accountStatementReport()
    {        
        $start = Carbon::now()->startOfMonth();

        $end = today();
        return view('accounts.accountStatement.index', [
            'start' => $start,
            'end'   => $end
        ]);
    }

    public function accountStatementSearch(Request $request)
    {

        

        //for Income
        $start = Carbon::parse($request->from_date ?? today()->startOfMonth());
        $end =  Carbon::parse($request->to_date ?? today()->endOfMonth());

        // dd($request->from_date);

        

        $incomes = Income::whereBetween('date',[$start,$end])->get()->groupBy('incomeHead');
        $previous_income = Income::where('date','<',$start)->sum('amount');
        $income_heads = IncomeHead::get();
        $income_head_with_sash[]=[];
        foreach($income_heads as $head)
        {
            $income_head_with_sash[$head->id] = $head->name;
        }

        //for expence
        $start_for_expense = Carbon::parse($request->from_date)->format('Y-m-d 00:00:00');
        $end_for_expense = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');
        $expences = Expense::where('status','approved')->whereBetween('date',[$start_for_expense,$end_for_expense])->get()->groupBy('expenseHead');
        $previous_expense = Expense::where('status','approved')->where('date','<',$start_for_expense)->sum('amount');
        $expense_heads = ExpenseHead::get();
        $expense_head_with_sash[]=[];
        foreach($expense_heads as $head)
        {
            $expense_head_with_sash[$head->id] = $head->name;
        }

        $data=[
            'incomes'=>$incomes,
            'income_head_with_sash' => $income_head_with_sash,
            'expenses'=>$expences,
            'expense_head_with_sash'=>$expense_head_with_sash,
            'previous_income' => $previous_income,
            'previous_expense'=> $previous_expense,
            'start' => $start,
            'end'   => $end
        ];

        return view('accounts.accountStatement.result',$data);
    }
}
