<?php

namespace App\Http\Controllers\Accounting;

use Carbon\Carbon;
use App\Models\IncomeHead;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\File;

class IncomeHeadController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:income-section|income-entry|income-head|income-report|other-income', ['only' => ['index', 'show']]);
        $this->middleware('permission:income-entry', ['only' => ['create', 'store']]);
        $this->middleware('permission:income-entry', ['only' => ['edit', 'update']]);
    }

    public function index()
    {
        $data = [
            'incomeheads' => IncomeHead::all(),
        ];
        // $incomes = Income::all();
        return view('accounts.incomeHead.index', $data);
    }


    public function create()
    {
        $data = [
            'incomeheads' => IncomeHead::get(),
        ];
        return view('accounts.incomeHead.create', $data);
    }


    public function store(Request $request)
    {
        $income = new IncomeHead();
        $income->fill($request->all());
        $income->save();
        Toastr::success('Income Head Successfully Saved' ,'Success');
        return redirect()->route('income-head.create');
    }


    public function show(IncomeHead $income)
    {
        //
    }


    public function edit($id)
    {
        $income = IncomeHead::find($id);
        $data = [
            'model' => $income,
            'title' => 'Income Head'
        ];
        return view('accounts.incomeHead.edit', $data);
    }


    public function update(Request $request)
    {
       // dd($request->all());
        $incomes = IncomeHead::find($request->id);
        $request->validate([
            //       'teacher_id' => 'required|unique:subjects,name,' . $complain->id,
            // 'phone' => 'required|regex:/^([0-9\s\-\+\(\)]*)$/|digits:11|unique:complains,phone,' . $request->id,
        ]);
        $incomes->fill($request->all());
        $incomes->update();
        Toastr::success('Income Head Successfully Update' ,'Success');
        return redirect()->route('income-head.create');
    }


    public function destroy(IncomeHead $incomeHead)
    {
        if(!in_array($incomeHead->id,[1,2,3,4,5,6,11])){
            $incomeHead->delete();
            return redirect()->route('income-head.index');
        }else{
            return redirect()->back()->with('error_message','Not Permited');

        }
    }
}
