<?php

namespace App\Http\Controllers\Api;

use App\Classes\BillgenerateUpdate;
use Carbon\Carbon;
use App\Models\Client;
use App\Models\Billpayment;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaymentDeleteController;
use App\Models\PayBillLog;

class BillPaymentController extends Controller
{
    //

    public function checkAuth($request)
    {
        if ($request->app_key == config('app.nagad_app') && $request->secret == config('app.nagad_secret')) {
            return true;
        } elseif ($request->app_key == config('app.bkash_app') && $request->secret == config('app.bkash_secret')) {
            return true;
        } elseif ($request->app_key == config('payment.UPAY_PAYBILL_APP_KEY') && $request->secret == config('payment.UPAY_PAYBILL_SECRET')) {
            return true;
        } else {
            return false;
        }
    }

    public function checkBill(Request $request)
    {
        $response = null;

        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;




        if ($this->checkAuth($request)) {

            if (preg_match('/[a-zA-Z]/', $request->customer_id)) {
                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Customer Id invalid',
                ];
            } else {
                $client = Client::with('pop', 'clientsinfo', 'customerAccount')->where('id', (int)$request->customer_id)->first();

                if ($client && $client->pop->bill_generate == 'yes') {

                    $token = Hash::make(Str::random(60) . now()->timestamp . $client->id);

                    $client->payment_token = $token;
                    $client->app_key_type = $request->app_key;
                    $client->save();

                    if ($client->customerAccount->dueAmount > 0) {

                        $response = [
                            'name' => $client->clientsinfo->clients_name,
                            'contact' => $client->clientsinfo->contact_no,
                            'bill_amount' => $client->customerAccount->dueAmount > 0.0 ? $client->customerAccount->dueAmount : 0.0,
                            'ErrorCode' => 200,
                            'ErrorMessage' => 'Success'
                        ];
                    } else {
                        $response = [
                            'name' => $client->clientsinfo->clients_name,
                            'contact' => $client->clientsinfo->contact_no,
                            'bill_amount' => number_format(0, 2),
                            'ErrorCode' => 436,
                            'ErrorMessage' => 'Bill Already Paid',
                        ];
                    }
                } else {
                    $response = [
                        'ErrorCode' => 404,
                        'ErrorMessage' => 'Customer Id invalid',
                    ];
                }
            }
        } else {
            $response = [
                'ErrorCode' => 401,
                'ErrorMessage' => 'Unauthorized'
            ];
        }

        $payBillLog->response = json_encode($response);
        $payBillLog->request_url = "check_bill";
        $payBillLog->save();

        return response()->json($response, $response['ErrorCode']);
    }

    public function payment(Request $request)
    {
        $response = null;
        $error_message = null;

        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;
        $payBillLog->trxn_id = $request->trx_id;
        $payBillLog->request_url = "payment";

        if ($this->checkAuth($request)) {
            $client = Client::with('pop', 'clientsinfo', 'customerAccount')
                ->where('id', $request->customer_id)
                ->first();
            if ($client) {

                $bill = $client->customerAccount->dueAmount > 0.0 ? $client->customerAccount->dueAmount : 0.0;

                if ($bill <= 0) {
                    $response = [
                        'ErrorCode' => 436,
                        'ErrorMessage' => 'Bill Already Paid',
                    ];
                    $error_message = 'Bill Already Paid';
                } else {

                    if ($bill == $request->amount) {
                        $result = (new PaymentController)->billPayPayment($request->trx_id, $request->customer_id, $request->amount, $request->mobile_no, $request->datetime, $client->app_key_type, 'billpay');

                        if ($result['status'] == 'success') {
                            $response = [
                                'result' => $result['status'],
                                'paymentAmount' => number_format($request->amount,2),
                                'ErrorCode' => 200,
                                'ErrorMessage' => 'Success'
                            ];
                        } else {
                            $response = [
                                'ErrorCode' => 409,
                                'ErrorMessage' => $result['status']
                            ];

                            $error_message = $result['message'];
                        }
                    } else {

                        $response = [
                            'result' => 'Amount mismatch',
                            'paymentAmount' => $request->amount,
                            'ErrorCode' => 435,
                            'ErrorMessage' => 'amount mismatch'
                        ];

                        $error_message = 'Amount mismatch';
                    }
                }
            } else {

                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Customer Id not found'
                ];
                $error_message = 'Customer Id not found';
            }
        } else {
            $response = [
                'ErrorCode' => 400,
                'ErrorMessage' => 'Bad Request'
            ];

            $error_message = 'Bad Request';
        }
        $payBillLog->response = json_encode($response);
        $payBillLog->error_message = $error_message;
        $payBillLog->save();

        return response()->json($response, $response['ErrorCode']);
    }


    public function search(Request $request)
    {
        $response = null;
        $error_message = null;

        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;
        $payBillLog->trxn_id = $request->trx_id;
        $payBillLog->request_url = "search";

        if ($this->checkAuth($request)) {

            $payment = $payment = Billpayment::with('clients', 'clientsinfo')
                ->where('money_receipt_number', $request->app_key . '_' . $request->trx_id)
                ->where('trx_id', $request->trx_id)
                ->first();
            // dd($payment,);
            if ($payment) {

                $data = [
                    'name' => $payment->clientsinfo->clients_name,
                    'customer_id' => strval($payment->clients->id),
                    'paid_amount' => $payment->paid_amount,
                    'trxId' => $payment->trx_id,
                    'datetime' => $payment->paymentCreateTime,
                    'ErrorCode' => 200,
                    'ErrorMessage' => 'Success'
                ];

                $response = $data;
                // return response()->json($data, 200);
            } else {

                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Not Found'
                ];

                $error_message = 'Not Found';

                // return response()->json([
                //     'ErrorCode' => 404,
                //     'ErrorMessage' => 'Not Found'
                // ], 404);
            }
        } else {
            $response = [
                'ErrorCode' => 401,
                'ErrorMessage' => 'Unauthorized'
            ];

            $error_message = 'Unauthorized';
            // return response()->json([
            //     'ErrorCode' => 401,
            //     'ErrorMessage' => 'Unauthorized'
            // ], 401);
        }

        $payBillLog->response = json_encode($response);
        $payBillLog->error_message = $error_message;
        $payBillLog->save();

        return response()->json($response, $response['ErrorCode']);
    }

    public function delete(Request $request)
    {

        if ($this->checkAuth($request)) {

            $payment = Billpayment::where('money_receipt_number', $request->app_key . '_' . $request->trx_id)->where('trx_id', '=', $request->trx_id)->first();

            if ($payment) {
                DB::beginTransaction();
                try {
                    $payment = Billpayment::with('user', 'income')->find($payment->id);

                    $amount = floatval($payment->paid_amount) + floatval($payment->discount_amount);

                    $paid_amount = floatval($payment->paid_amount);

                    $clientIdForThisBillDelete = PaymentDeleteController::deletePayment($payment, $amount, $paid_amount);

                    DB::commit();

                    (new BillgenerateUpdate)->update($clientIdForThisBillDelete);

                    return response()->json([
                        'ErrorCode' => 200,
                        'ErrorMessage' => 'Success'
                    ], 200);
                } catch (\Exception $e) {
                    DB::rollback();
                    return response()->json([
                        'ErrorCode' => 500,
                        'ErrorMessage' => $e->getMessage()
                    ], 500);
                }
            } else {
                // dd("vc");
                return response()->json([
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Not Found'
                ], 404);
            }
        } else {
            return response()->json([
                'ErrorCode' => 401,
                'ErrorMessage' => 'Unauthorized'
            ], 401);
        }
    }
}
