<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Client;
use App\Models\PayBillLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Http\Controllers\PaymentController;
use App\Models\Billpayment;

class PrepaidBillPaymentController extends Controller
{

    public function checkAuth($request)
    {
        if ($request->app_key == config('app.nagad_app') && $request->secret == config('app.nagad_secret')) {
            return true;
        } elseif ($request->app_key == config('app.bkash_app') && $request->secret == config('app.bkash_secret')) {
            return true;
        } elseif ($request->app_key == config('payment.UPAY_PAYBILL_APP_KEY') && $request->secret == config('payment.UPAY_PAYBILL_SECRET')) {
            return true;
        } else {
            return false;
        }
    }

    public function checkPrepaidBill(Request $request)
    {
        $response = null;
        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;

        if ($this->checkAuth($request)) {
            if (checkSettings('prepaid-bill-by-client-username') == 'disable' && checkSettings('prepaid-bill-by-client-code') == 'disable' && preg_match('/[a-zA-Z]/', $request->customer_id)) {
                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Customer Id invalid',
                ];
            } else {
                $list = Client::with('pop', 'clientsinfo', 'customerAccount');

                if (checkSettings('prepaid-bill-by-client-username') == 'enable' && checkSettings('prepaid-bill-by-client-code') == 'disable') {
                    $client = $list->where('userid', $request->customer_id)->first();
                } else if (checkSettings('prepaid-bill-by-client-code') == 'enable' && checkSettings('prepaid-bill-by-client-username') == 'disable') {
                    $client = $list->where('customer_code', $request->customer_id)->first();
                } else {
                    $client = $list->where('id', (int)$request->customer_id)->first();
                }

                if ($client && $client->pop->bill_generate == 'yes') {
                    $token = Hash::make(Str::random(60) . now()->timestamp . $client->id);
                    $client->payment_token = $token;
                    $client->app_key_type = $request->app_key;
                    $client->save();

                    $response = [
                        'name' => $client->clientsinfo->clients_name,
                        'contact' => $client->clientsinfo->contact_no,
                        'bill_amount' => $client->customerAccount->dueAmount > 0 ? $client->customerAccount->dueAmount : 0,
                        'ErrorCode' => 200,
                        'ErrorMessage' => 'Success'
                    ];
                } else {
                    $response = [
                        'ErrorCode' => 404,
                        'ErrorMessage' => 'Customer Id invalid',
                    ];
                }
            }
        } else {
            $response = [
                'ErrorCode' => 401,
                'ErrorMessage' => 'Unauthorized'
            ];
        }

        $payBillLog->response = json_encode($response);
        $payBillLog->request_url = "bill-check";
        $payBillLog->save();
        return response()->json($response, $response['ErrorCode']);
    }

    public function prePayment(Request $request)
    {
        $response = null;
        $error_message = null;
        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;
        $payBillLog->trxn_id = $request->trx_id;
        $payBillLog->request_url = "pre-payment";

        if ($this->checkAuth($request)) {
            $list = Client::with('pop', 'clientsinfo', 'customerAccount');

            if (checkSettings('prepaid-bill-by-client-username') == 'enable' && checkSettings('prepaid-bill-by-client-code') == 'disable') {
                $client = $list->where('userid', $request->customer_id)->first();
            } else if (checkSettings('prepaid-bill-by-client-code') == 'enable' && checkSettings('prepaid-bill-by-client-username') == 'disable') {
                $client = $list->where('customer_code', $request->customer_id)->first();
            } else {
                $client = $list->where('id', $request->customer_id)->first();
            }

            if ($client) {
                $result = (new PaymentController)->billPayPayment($request->trx_id, $client->id, $request->amount, $request->mobile_no, $request->datetime, $client->app_key_type, 'prepaidBillPay');

                if ($result['status'] == 'success') {
                    $response = [
                        'result' => $result['status'],
                        'paymentAmount' => $request->amount,
                        'ErrorCode' => 200,
                        'ErrorMessage' => 'Success'
                    ];
                } else {
                    $response = [
                        'ErrorCode' => 409,
                        'ErrorMessage' => $result['status']
                    ];
                    $error_message = $result['message'];
                }
            } else {
                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Customer Id not found'
                ];
                $error_message = 'Customer Id not found';
            }
        } else {
            $response = [
                'ErrorCode' => 400,
                'ErrorMessage' => 'Bad Request'
            ];
            $error_message = 'Bad Request';
        }

        $payBillLog->response = json_encode($response);
        $payBillLog->error_message = $error_message;
        $payBillLog->save();
        return response()->json($response, $response['ErrorCode']);
    }

    public function billSearch(Request $request)
    {
        $response = null;
        $error_message = null;
        $payBillLog = new PayBillLog();
        $payBillLog->payment_method = $request->app_key;
        $payBillLog->request = json_encode($request->all());
        $payBillLog->client_id = $request->customer_id;
        $payBillLog->trxn_id = $request->trx_id;
        $payBillLog->request_url = "bill-search";

        if ($this->checkAuth($request)) {
            $payment = $payment = Billpayment::with('clients', 'clientsinfo')
                ->where('money_receipt_number', $request->app_key . '_' . $request->trx_id)
                ->where('trx_id', $request->trx_id)->first();

            if ($payment) {
                $customer_id_info = '';
                if (checkSettings('prepaid-bill-by-client-username') == 'enable' && checkSettings('prepaid-bill-by-client-code') == 'disable') {
                    $customer_id_info = $payment->clients->userid;
                } else if (checkSettings('prepaid-bill-by-client-code') == 'enable' && checkSettings('prepaid-bill-by-client-username') == 'disable') {
                    $customer_id_info = $payment->clients->customer_code;
                } else {
                    $customer_id_info = $payment->clients->id;
                }

                $data = [
                    'name' => $payment->clientsinfo->clients_name,
                    'customer_id' => $customer_id_info,  // $payment->clients->id,
                    'paid_amount' => $payment->paid_amount,
                    'trxId' => $payment->trx_id,
                    'datetime' => $payment->paymentCreateTime,
                    'ErrorCode' => 200,
                    'ErrorMessage' => 'Success'
                ];

                $response = $data;
            } else {
                $response = [
                    'ErrorCode' => 404,
                    'ErrorMessage' => 'Not Found'
                ];
                $error_message = 'Not Found';
            }
        } else {
            $response = [
                'ErrorCode' => 401,
                'ErrorMessage' => 'Unauthorized'
            ];

            $error_message = 'Unauthorized';
        }

        $payBillLog->response = json_encode($response);
        $payBillLog->error_message = $error_message;
        $payBillLog->save();
        return response()->json($response, $response['ErrorCode']);
    }
}
