<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\Clientsinfo;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerArea;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getResellerAreaPop(Request $request)
    {
        $pop_list = Pop::list()->where('reseller_id', $request->id);
        $area_list = [];
        if(checkSettings('area-dropdown')=="disable"){
           $area =  Clientsinfo::where('area','!=',null)->groupBy('area')->pluck('area');

        }else{

            $area = ResellerArea::where('reseller_id', $request->id)->groupBy('area')->pluck('area');

        }
        $pop=[];
        foreach ($pop_list as $key => $value) {
            $pop[] = $value;
        }
        $data = [
            'areas' => $area,
            'pops' => $pop,
        ];
        return $data;
    }

    public function getPopAreaList(Request $request)
    {
        if(checkSettings('area-dropdown')=="disable"){
            $area =  Clientsinfo::where('area','!=',null)->groupBy('area')->pluck('area');
         }else{
             $area = ResellerArea::where('pop_id', $request->id)->groupBy('area')->pluck('area');
         }
        $data = [
            'areas' => $area,
        ];
        return $data;
    }
}
