<?php

namespace App\Http\Controllers;

use App\Models\BandProvider;
use App\Models\BandPurchase;
use App\Models\BandPurchaseItem;
use App\Models\BandService;
use App\Models\BandStock;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BandPurchaseController extends Controller
{

    public function index()
    {
        $data = [
            'list' => BandPurchase::get()
        ];

        return view('bandPurchase.index', $data);
    }

    public function create()
    {
        $data = [
            'provider' => BandProvider::all(),
            'start' => Carbon::now()->startOfMonth(),
            'end' => today()
        ];

        return view('bandPurchase.create', $data);
    }

    public function productinfo(Request $request)
    {
        $product = BandService::where('id', $request->data)->first();
        return $product;
    }

    public function productDetails(Request $request)
    {
        $name = $request->data;
        $product = BandService::where('name', 'like', "%{$name}%")->get();

        return $product;
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'invoice_no' => 'required|unique:band_purchases,invoice_no',
        ]);

        DB::beginTransaction();
        try {

            $purchase = new BandPurchase();
            // $purchase->bill_no = 11;
            $purchase->provider_id = $request->provider_id;
            $purchase->invoice_no = $request->invoice_no;
            $purchase->billing_date = $request->billing_date;
            $purchase->subTotal = $request->subTotal;
            $purchase->total_qty = $request->total_qty;
            $purchase->marketing_total = $request->marketing_total;
            $purchase->total = $request->total;

            if ($request->document != null) {
                $fileName = time() . '.' . $request->document->extension();
                $request->document->move(storage_path('app/public/bandPurchase'), $fileName);
                $purchase->document = $fileName;
            }

            $purchase->save();

            $temp_SL_id = str_pad($purchase->id, 6, '0', STR_PAD_LEFT);
            $purchase->bill_no = "BIL-" . $temp_SL_id;
            $purchase->update();

            $len = sizeof($request->service_id);
            for ($i = 0; $i < $len; $i++) {
                $purchaseItem = new BandPurchaseItem();
                $purchaseItem->bandPurchaseId = $purchase->id;
                $purchaseItem->service_id = $request->service_id[$i];
                $purchaseItem->quantity = $request->quantity[$i];
                $purchaseItem->rate = $request->rate[$i];
                $purchaseItem->vat = $request->vat[$i];
                $purchaseItem->from_date = $request->from_date[$i];
                $purchaseItem->to_date = $request->to_date[$i];
                $purchaseItem->status = $request->status[$i];
                $purchaseItem->line_total = $request->line_total[$i];
                $purchaseItem->save();

                $stock_of_this_product = BandStock::where('service_id', $request->service_id[$i])->where('rate', $request->rate[$i])->first();
                if ($stock_of_this_product) {
                    $stock_of_this_product->quantity = $stock_of_this_product->quantity + intval($request->quantity[$i]);
                    $stock_of_this_product->rate = $request->rate[$i];
                    $stock_of_this_product->vat = $request->vat[$i];
                    $stock_of_this_product->save();
                } else {
                    $new_stock_for_this_product = new BandStock();
                    $new_stock_for_this_product->service_id = $request->service_id[$i];
                    $new_stock_for_this_product->quantity = intval($request->quantity[$i]);
                    $new_stock_for_this_product->rate = $request->rate[$i];
                    $new_stock_for_this_product->vat = $request->vat[$i];
                    $new_stock_for_this_product->save();
                }
            }

            DB::commit();
            Toastr::success('Purchase Added Successfully', '', ["progressBar" => true]);
            return back();
        } catch (\Exception $ex) {
            DB::rollback();
            Toastr::error('Some Problem Happen', '', ["progressBar" => true]);
            dd($ex);
            return back();
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = [
            'purchase' => BandPurchase::with('purchaseItem.service')->find($id),
            'provider' => BandProvider::all(),
            'start' => Carbon::now()->startOfMonth(),
            'end' => today()
        ];

        return view('bandPurchase.edit', $data);
    }

    public function update(Request $request, $id)
    {
        // dd($request->all());
        $purchaseId = BandPurchase::find($id);
        $this->validate($request, [
            'invoice_no' => 'unique:band_purchases,invoice_no,' . $purchaseId->id,
        ]);

        DB::beginTransaction();
        try {
            $purchase = BandPurchase::find($id);
            $purchase->provider_id = $request->provider_id;
            $purchase->invoice_no = $request->invoice_no;
            $purchase->billing_date = $request->billing_date;
            $purchase->subTotal = $request->subTotal;
            $purchase->total_qty = $request->total_qty;
            $purchase->marketing_total = $request->marketing_total;
            $purchase->total = $request->total;
            $purchase->bill_no = $request->bill_no;

            if ($request->document != null) {
                $fileName = time() . '.' . $request->document->extension();
                $request->document->move(storage_path('app/public/bandPurchase'), $fileName);
                $purchase->document = $fileName;
            }

            $purchase->update();

            $len = sizeof($request->service_id);
            for ($i = 0; $i < $len; $i++) {
                if (isset($request->purchase_item_id[$i])) {
                    $purchaseItemold = BandPurchaseItem::where('id', $request->purchase_item_id[$i])->first();
                    // dd($purchaseItemold->rate);
                    // $stock_for_reduse_previous_add = BandStock::where('service_id', $request->service_id[$i])->where('rate', $purchaseItemold->rate[$i])->first();
                    // dd($stock_for_reduse_previous_add);

                    // if ($stock_for_reduse_previous_add) {
                    //     $stock_for_reduse_previous_add->quantity = $stock_for_reduse_previous_add->quantity - $purchaseItemold->quantity;
                    //     $stock_for_reduse_previous_add->rate = $request->rate[$i];
                    //     $stock_for_reduse_previous_add->vat = $request->vat[$i];
                    //     $stock_for_reduse_previous_add->save();
                    // } else {
                    //     Toastr::error('Some Problem Happen', '', ["progressBar" => true]);
                    //     return back();
                    // }

                    $purchaseItemold->bandPurchaseId = $purchase->id;
                    $purchaseItemold->service_id = $request->service_id[$i];
                    $purchaseItemold->quantity = $request->quantity[$i];
                    $purchaseItemold->rate = $request->rate[$i];
                    $purchaseItemold->vat = $request->vat[$i];
                    $purchaseItemold->from_date = $request->from_date[$i];
                    $purchaseItemold->to_date = $request->to_date[$i];
                    $purchaseItemold->status = $request->status[$i];
                    $purchaseItemold->line_total = $request->line_total[$i];
                    $purchaseItemold->update();

                    $stock_of_this_product_for_add = BandStock::where('service_id', $request->service_id[$i])->where('rate', $request->rate[$i])->first();
                    if ($stock_of_this_product_for_add) {
                        $stock_of_this_product_for_add->quantity = $stock_of_this_product_for_add->quantity + intval($request->quantity[$i]);
                        $stock_of_this_product_for_add->rate = $request->rate[$i];
                        $stock_of_this_product_for_add->vat = $request->vat[$i];
                        $stock_of_this_product_for_add->save();
                    } else {
                        $new_stock_for_this_product = new BandStock();
                        $new_stock_for_this_product->service_id = $request->service_id[$i];
                        $new_stock_for_this_product->quantity = intval($request->quantity[$i]);
                        $new_stock_for_this_product->rate = $request->rate[$i];
                        $new_stock_for_this_product->vat = $request->vat[$i];
                        $new_stock_for_this_product->save();
                    }
                } else {
                    $purchaseItem = new BandPurchaseItem();
                    $purchaseItem->bandPurchaseId = $purchase->id;
                    $purchaseItem->service_id = $request->service_id[$i];
                    $purchaseItem->quantity = $request->quantity[$i];
                    $purchaseItem->rate = $request->rate[$i];
                    $purchaseItem->vat = $request->vat[$i];
                    $purchaseItem->from_date = $request->from_date[$i];
                    $purchaseItem->to_date = $request->to_date[$i];
                    $purchaseItem->status = $request->status[$i];
                    $purchaseItem->line_total = $request->line_total[$i];
                    $purchaseItem->save();

                    $stock_of_this_product = BandStock::where('service_id', $request->service_id[$i])->where('rate', $request->rate[$i])->first();
                    if ($stock_of_this_product) {
                        $stock_of_this_product->quantity = $stock_of_this_product->quantity + intval($request->quantity[$i]);
                        $stock_of_this_product->rate = $request->rate[$i];
                        $stock_of_this_product->vat = $request->vat[$i];
                        $stock_of_this_product->save();
                    } else {
                        $new_stock_for_this_product = new BandStock();
                        $new_stock_for_this_product->service_id = $request->service_id[$i];
                        $new_stock_for_this_product->quantity = intval($request->quantity[$i]);
                        $new_stock_for_this_product->rate = $request->rate[$i];
                        $new_stock_for_this_product->vat = $request->vat[$i];
                        $new_stock_for_this_product->save();
                    }
                }
            }

            DB::commit();
            Toastr::success('Purchase Updated Successfully', '', ["progressBar" => true]);
            return redirect(route('band-purchase.index'));
        } catch (\Exception $ex) {
            DB::rollback();
            Toastr::error('Some Problem Happen', '', ["progressBar" => true]);
            dd($ex);
            return back();
        }
    }

    public function destroy($id)
    {
        //
    }

    public function makePayment(Request $request)
    {
        // dd($request->all());

        $purchase = BandPurchase::find($request->purchaseId);
        $purchase->subTotal = $request->subTotal;
        $purchase->marketing_total = $request->paid + $request->newPaid;
        $purchase->total = $request->due;
        $purchase->update();

        Toastr::success('Paid Successfully', '', ["progressBar" => true]);
        return redirect(route('band-purchase.index'));
    }

    public function invoice($id)
    {
        $data = [
            'invoice' => BandPurchase::with('purchaseItem.service', 'provider')->find($id),
        ];

        // dd($data['invoice']);

        return view('bandPurchase.invoice', $data);
    }
}
