<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class CRMClientController extends Controller
{
    public function crmcClients(){

        $list = Client::list();

        $crm_status = [];
        //check permission
        if(auth()->user()->can('crm_marketing')){
            array_push($crm_status, 'Marketing');
        }

        if(auth()->user()->can('crm_crm')){
            array_push($crm_status, 'CRM');
        }

        if(auth()->user()->can('crm_support')){
            array_push($crm_status, 'Support');
        }

        if(auth()->user()->can('crm_account')){
            array_push($crm_status, 'Account');
        }

        if(auth()->user()->can('crm_fiber')){
            array_push($crm_status, 'Fiber');
        }

        if(auth()->user()->can('crm_store')){
            array_push($crm_status, 'Store');
        }



        $data = [
            'list' => $list->where('clients_status', '!=', 'active')->where('clients_status', '!=', 'disable')->whereIn('crm_status',$crm_status)->paginate(100),
            'type' => "",
        ];
        // dd($data);

        return view('crm.client.list', $data);
    }

    public function crmcClientsByTpye($type){


      $permission =  "crm_".strtolower($type);
      if(!auth()->user()->can($permission)){
           Toastr::error('You do not have permission to access this','Error');
           return redirect()->back();
        }

        $list = Client::list();
        $data = [
            'list' => $list->where('clients_status', '!=', 'active')->where('clients_status', '!=', 'disable')->where('crm_status',$type)->paginate(100),
            'type' => $type,
        ];


        return view('crm.client.list', $data);

    }

    public function crmCustomerSearch(Request $request){
     if (request()->ajax()) {

            $uid = auth()->user()->id;
            $con = $request->search;
            $pop_ids = Client::pop_ids();
            $permissions = auth()->user()->getAllPermissions()->pluck('name')->toArray();

            if($request->type){
                $list = Client::list()->where('clients_status', '!=', 'active')->where('clients_status', '!=', 'disable')->where('crm_status',$request->type);

            }else{
                $crm_status = [];
                    if(auth()->user()->can('crm_marketing')){
                        array_push($crm_status, 'Marketing');
                    }

                    if(auth()->user()->can('crm_crm')){
                        array_push($crm_status, 'CRM');
                    }

                    if(auth()->user()->can('crm_support')){
                        array_push($crm_status, 'Support');
                    }

                    if(auth()->user()->can('crm_account')){
                        array_push($crm_status, 'Account');
                    }

                    if(auth()->user()->can('crm_fiber')){
                        array_push($crm_status, 'Fiber');
                    }

                    if(auth()->user()->can('crm_store')){
                        array_push($crm_status, 'Store');
                    }
                $list = Client::list()->where('clients_status', '!=', 'active')->where('clients_status', '!=', 'disable')->whereIn('crm_status',$crm_status);
            }
            // dd("comes");
            if ($request->crm_check_date) {

                $list->where('crm_check_date', $request->crm_check_date);
            }


            if ($request->id) {
                $list->where('id', $request->id);
            }

            if ($request->username) {
                $list->where('userid', 'like', '%' . $request->username . '%');
            }

            if ($request->contact) {
                $list->whereHas('clientsinfo', function ($q) use ($request) {
                    $q->where('contact_no', 'like', '%' . $request->contact . '%');
                });
            }

            if ($request->box) {
                $list->whereHas('clientsinfo', function ($q) use ($request) {
                    $q->where('box', 'like', '%' . $request->box . '%');
                });
            }

            if ($request->area) {
                $list->whereHas('clientsinfo', function ($q) use ($request) {
                    $q->where('area', 'like', '%' . $request->area . '%');
                });
            }
            if ($request->customername) {
                $list->whereHas('clientsinfo', function ($q) use ($request) {
                    $q->where('clients_name', 'like', '%' . $request->customername . '%')
                        ->orWhere('father_name', 'like', '%' . $request->customername . '%')
                        ->orWhere('mother_name', 'like', '%' . $request->customername . '%')
                        ->orWhere('flat_no', 'like', '%' . $request->customername . '%')
                        ->orWhere('building_no', 'like', '%' . $request->customername . '%')
                        ->orWhere('building_name', 'like', '%' . $request->customername . '%')
                        ->orWhere('other_contact', 'like', '%' . $request->customername . '%')
                        ->orWhere('road_no', 'like', '%' . $request->customername . '%');
                });
            }

            $list = $list->take(100)->get();


            if (checkAPI()) {
                $online = mikrotikOnlineAndOfflineUsers();
            } else {
                $online = Client::online($list->pluck('userid'));
            }

            return view('clients.customer_search', [
                'list' => $list,
                'online' => $online,
                'permissions' => $permissions,
            ]);
        }


    }
}
