<?php

namespace App\Http\Controllers\Clients;

use App\Classes\MikrotikService\Mikrotik;
use App\Models\Pop;
use App\Models\Client;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\CustomerDelInfo;
use App\Models\Nas;
use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
use Exception;

class OflineCustomerController extends Controller
{
    public function oflineCustomer(Request $request)
    {

        if (auth()->user()->hasRole('Sub Reseller')) {
            $poplist = userPops();




            return view('clients.onlineofline.oflineCustomer', [
                'page_title' => 'Offline Customer List',
                'poplist' => $poplist,
                'reseller' => null
            ]);
        } else {

            $reseller_list =  Reseller::resellerList()->get();


            return view('clients.onlineofline.oflineCustomer', [
                'page_title' => 'Offline Customer List',
                'reseller' => $reseller_list,
                'poplist' => null
            ]);
        }
    }


    public function oflineCustomerResult(Request $request)
    {



        if (checkAPI()) {

            if ($request->pop && $request->reseller && $request->pop != 'all') {
                //offline customer for a selected reseller and selected pop
                $allUsersInMK = [];
                $pop = userPops()->find($request->pop);
                $users = Client::list()
                    ->where(function ($q) {
                        $q->where('clients_status', 'active')
                            ->orWhere('clients_status', 'expired');
                    })
                    ->where('pop_id', $request->pop)
                    ->pluck('userid')->toArray();

                $mkIp = $pop->nas->nasname;
                $mkUsername = $pop->nas->mikrotick_user;
                $mkPassword = $pop->nas->mikrotick_user_password;
                $mkPort = $pop->nas->mikrotick_port;
                $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                $allActiveUsers = $mk->getActiveConnection();
                $allUsers = $mk->getSecret();

                foreach ($allUsers as $user) {
                    $allUsersInMK[$user["name"]] = $user;
                }
                $storedActiveUser = [];
                foreach ($allActiveUsers as $user) {
                    $storedActiveUser[$user["name"]] = $user;
                }

                $result = [];

                $allClients = Client::with('clientsinfo', 'customerAccount', 'pop', 'subpack', 'packages')->whereIn('userid', $users)->get();

                foreach ($users as $user) {
                    if (!array_key_exists($user, $storedActiveUser)) {
                        //$offlineuser = Client::with('clientsinfo', 'customerAccount', 'pop', 'subpack', 'packages')->where('userid', $user)->first();

                        $offlineuser = $allClients->where('userid', $user)->first();
                        array_push($result, $offlineuser);
                    }
                }


                return view('clients.onlineofline.oflineResult', [
                    'list' => $result,
                    'all_customer' => $allUsersInMK,
                    'page_title' => 'ofline Customer List',
                ]);
            } else if ($request->pop && $request->reseller && $request->pop == 'all') {
                //offline customer for a selected reseller

                $popes = userPops()->where('reseller_id', $request->reseller);
                $storedActiveUser = [];
                $result = [];
                $allUsersInMK = [];
                foreach ($popes as $pop) {
                    try {
                        $users = Client::list()
                            ->where(function ($q) {
                                $q->where('clients_status', 'active')
                                    ->orWhere('clients_status', 'expired');
                            })
                            ->where('pop_id', $pop->id)
                            ->pluck('userid')->toArray();

                        $mkIp = $pop->nas->nasname;
                        $mkUsername = $pop->nas->mikrotick_user;
                        $mkPassword = $pop->nas->mikrotick_user_password;
                        $mkPort = $pop->nas->mikrotick_port;
                        $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                        $allActiveUsers = $mk->getActiveConnection();

                        $allUsers = $mk->getSecret();

                        foreach ($allUsers as $user) {
                            $allUsersInMK[$user["name"]] = $user;
                        }
                        foreach ($allActiveUsers as $user) {
                            $storedActiveUser[$user["name"]] = $user;
                        }

                        $allClients = Client::with('clientsinfo', 'customerAccount', 'pop', 'subpack', 'packages')->whereIn('userid', $users)->get();

                        foreach ($users as $user) {
                            if (!array_key_exists($user, $storedActiveUser)) {
                                $offlineuser = $allClients->where('userid', $user)->first();
                                array_push($result, $offlineuser);
                            }
                        }
                    } catch (Exception $e) {
                    }
                }


                return view('clients.onlineofline.oflineResult', [
                    'list' => $result,
                    'all_customer' => $allUsersInMK,
                    'page_title' => 'ofline Customer List',
                ]);
            } else if ($request->pop  && $request->pop != 'all') {
                //offline customer for sub reseller of selected pop
                try {
                    $allUsersInMK = [];
                    $pop = userPops()->find($request->pop);
                    $users = Client::list()
                        ->where(function ($q) {
                            $q->where('clients_status', 'active')
                                ->orWhere('clients_status', 'expired');
                        })
                        ->where('pop_id', $request->pop)
                        ->pluck('userid')->toArray();

                    $mkIp = $pop->nas->nasname;
                    $mkUsername = $pop->nas->mikrotick_user;
                    $mkPassword = $pop->nas->mikrotick_user_password;
                    $mkPort = $pop->nas->mikrotick_port;
                    $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                    $allActiveUsers = $mk->getActiveConnection();
                    $allUsers = $mk->getSecret();

                    foreach ($allUsers as $user) {
                        $allUsersInMK[$user["name"]] = $user;
                    }
                    $storedActiveUser = [];
                    foreach ($allActiveUsers as $user) {
                        $storedActiveUser[$user["name"]] = $user;
                    }



                    $result = [];
                    $allClients = Client::with('clientsinfo', 'customerAccount', 'pop', 'subpack', 'packages')->whereIn('userid', $users)->get();
                    foreach ($users as $user) {
                        if (!array_key_exists($user, $storedActiveUser)) {
                            $offlineuser = $allClients->where('userid', $user)->first();
                            array_push($result, $offlineuser);
                        }
                    }
                } catch (Exception $e) {
                }



                return view('clients.onlineofline.oflineResult', [
                    'list' => $result,
                    'all_customer' => $allUsersInMK,
                    'page_title' => 'ofline Customer List',
                ]);
            } else {

                //offline customer for all reseller and pop
                $popes = Pop::conditionalList();
                $storedActiveUser = [];
                $result = [];
                $allUsersInMK = [];
                $users = Client::list()->where(function ($q) {
                    $q->where('clients_status', 'active')
                        ->orWhere('clients_status', 'expired');
                })
                    ->pluck('userid')->toArray();
                $mikrotiks = Nas::get();
                try {
                    foreach ($mikrotiks as $mikrotik) {

                        // $pop = Pop::with("nas")->find($request->pop);

                        $mkIp = $mikrotik->nasname;
                        $mkUsername = $mikrotik->mikrotick_user;
                        $mkPassword = $mikrotik->mikrotick_user_password;
                        $mkPort = $mikrotik->mikrotick_port;
                        $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                        $allActiveUsers = $mk->getActiveConnection();

                        $allUsers = $mk->getSecret();

                        foreach ($allUsers as $user) {
                            $allUsersInMK[$user["name"]] = $user;
                        }
                        foreach ($allActiveUsers as $user) {
                            $storedActiveUser[$user["name"]] = $user;
                        }
                    }
                } catch (Exception $e) {
                }


                $allClients = Client::with('clientsinfo', 'customerAccount', 'pop', 'subpack', 'packages')->whereIn('userid', $users)->get();

                foreach ($users as $user) {
                    if (!array_key_exists($user, $storedActiveUser)) {
                        $offlineuser = $allClients->where('userid', $user)->first();
                        array_push($result, $offlineuser);
                    }
                    // $offlineuser = Client::where('userid', $user)->get();
                    //  dd($offlineuser);
                }

                return view('clients.onlineofline.oflineResult', [
                    'list' => $result,
                    'all_customer' => $allUsersInMK,
                    'page_title' => 'ofline Customer List',
                ]);
            }
        } else {
            if ($request->pop || $request->reseller) {

                $pop_ids = Pop::poplist();

                if ($request->reseller == null) {
                    $pop_ids = Pop::poplist()->pluck('id')->toArray();
                }

                if ($request->reseller != null && $request->pop == 'all') {
                    $pop_ids = Pop::poplist()->where('reseller_id', $request->reseller)->pluck('id')->toArray();
                }

                if ($request->pop != 'all' && $request->pop != null) {
                    $pop_ids = Pop::poplist()->where('id', $request->pop)->pluck('id')->toArray();
                }



                $clientList = Client::list()->where('clients_status', 'active')
                    ->whereIn('pop_id', $pop_ids)
                    // ->select('userid')
                    ->select('userid')
                    ->pluck('userid');


                $online = DB::table('radacct')
                    ->select('username')
                    ->whereNull('acctstoptime')
                    ->whereIn('username', $clientList)
                    ->pluck('username');


                $list =    $clientList->diff($online)->toArray();


                // $oflinelist = DB::table('radacct')
                //     ->whereIn('username', $list)
                //     ->orderBy('radacctid', 'desc')
                //     ->groupBy('username')
                //     ->get();

                $latestRecords = DB::table('radacct')
                    ->select('username', DB::raw('MAX(radacctid) as max_radacctid'))
                    ->whereIn('username', $list)
                    ->groupBy('username')
                    ->orderByDesc('max_radacctid')
                    ->get();

                $oflinelist = [];
                foreach ($latestRecords as $record) {
                    $latestRecord = DB::table('radacct')
                        ->where('username', $record->username)
                        ->where('radacctid', $record->max_radacctid)
                        ->first();
                    $oflinelist[] = $latestRecord;
                }


                return view('clients.onlineofline.oflineResult', [
                    'list' => $oflinelist,
                    'page_title' => 'ofline Customer List',
                ]);
            } else {
                echo '<p class="text-center text-danger">Please Select Reseller</p>';
            }
        }
    }


    public function offlineCustomerSearch(Request $request)
    {
        if ($request->ajax()) {
            $list = Client::where('clients_status', '!=', 'deactive');

            if ($request->reseller != null && $request->pop == 'all') {

                $reseller_ids = DB::table('reseller_user')->where('reseller_id', $request->reseller)->pluck('reseller_id')->toArray();
                $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();
                $list = $list->whereIn('pop_id', $pop_ids)->pluck('userid')->toArray();
            } elseif ($request->reseller != null && $request->pop != null) {

                $list = $list->where('pop_id', $request->pop)->pluck('userid')->toArray();
            }
        }

        $online = DB::table('radacct')
            ->select('*')
            ->where('acctstoptime')
            ->whereIn('username', $list)
            ->orderBy('radacctid', 'desc')
            ->paginate(5000);

        return view('offlineList.result', [
            'list' => $online,
            'page_title' => 'ofline Customer List',
        ]);
    }

    public function deletedCustomer()
    {
        $list = CustomerDelInfo::all();

        return view('clients.onlineofline.deletedCustomer', [
            'page_title' => 'Deleted Customer List',
            'list' => $list,
        ]);
    }
}
