<?php

namespace App\Http\Controllers\Clients;

use App\Models\Pop;
use App\Models\Client;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\CompanyInformation;
use Brian2694\Toastr\Facades\Toastr;

use App\Classes\MikrotikService\Mikrotik;
use App\Models\Nas;
use Exception;

class OnlineCustomerController extends Controller
{

    public function customer_list()
    {
        $pop_ids = Pop::poplist()->pluck('id')->toArray();

        $list = Client::whereIn('pop_id', $pop_ids)
            ->pluck('userid')
            ->toArray();

        return $list;
    }

    public function online_customer_list()
    {

        // previous code for online customer list
        // $online = DB::table('radacct')
        //     ->selectRaw('count(*) as total')
        //     ->whereNull('acctstoptime')
        //     ->whereIn('username', $this->customer_list())
        //     ->orderBy('radacctid', 'desc')
        //     ->get();

        // return $online;

        $online = 0; // Initialize an empty collection to store the results

        $usernames = $this->customer_list();

        // Chunk the usernames into smaller batches (e.g., 1000 at a time)
        foreach (array_chunk($usernames, 1000) as $chunk) {

            $result = DB::table('radacct')
                        ->whereNull('acctstoptime')
                        ->whereIn('username', $chunk)
                        ->count();

            $online += $result;
        }

        return $online;
    }



    public function onlineCustomer()
    {

        if (checkAPI()) {

        }

        $online = "";
        // dd($online);

        $resellers = Reseller::resellerList()->get();
        return view('clients.onlineofline.online', [
            'page_title' => 'Online Customer List',
            'list' => $online,
            'reseller'   =>  $resellers,
        ]);
    }


    public function onlineCustomerSearch(Request $request)
    {

          if (checkAPI()) {

            if ($request->ajax()) {
                $allMikrotikAndActiveUsers = [];

                $new_client = [];
                $count = 0;
                if ($request->pop != null && $request->pop != 'all') {
                    try {


                        $pop = Pop::with("nas")->find($request->pop);

                        $clients = Client::list()->where('clients_status', '!=', 'deactive')->where('pop_id', $request->pop)->get();

                        $mkIp = $pop->nas->nasname;
                        $mkUsername = $pop->nas->mikrotick_user;
                        $mkPassword = $pop->nas->mikrotick_user_password;
                        $mkPort = $pop->nas->mikrotick_port;
                        $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                        $allActiveUsers = $mk->getActiveConnection();

                        $mikrotikAndActiveUsers = [
                            "nasIp" => $mkIp,
                            "activeUsers" => []
                        ];

                        $currentActiveUsers = [];
                        foreach ($allActiveUsers as $user) {

                            $currentActiveUsers[$user["name"]] = $user;
                        }


                        foreach ($clients as $client) {
                            if (array_key_exists($client->userid, $currentActiveUsers)) {
                                array_push($mikrotikAndActiveUsers["activeUsers"], $currentActiveUsers[$client->userid]);
                                $count++;
                                $new_client[$client->userid] = $client->id;
                            }
                        }

                        array_push($allMikrotikAndActiveUsers, $mikrotikAndActiveUsers);
                    } catch (Exception $err) {

                    }
                } else if ($request->reseller != null && $request->pop == 'all') {
                    $pops = Pop::with("nas")->where("reseller_id", $request->reseller)->get();
                    // dd($pops);
                    // return $pops;
                    foreach ($pops as $pop) {
                        try {

                            $clients = Client::list()->where('clients_status', '!=', 'deactive')->where('pop_id', $pop->id)->get();

                            $mkIp = $pop->nas->nasname;
                            $mkUsername = $pop->nas->mikrotick_user;
                            $mkPassword = $pop->nas->mikrotick_user_password;
                            $mkPort = $pop->nas->mikrotick_port;
                            $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                            $allActiveUsers = $mk->getActiveConnection();
                            // return $allActiveUsers;
                            $mikrotikAndActiveUsers = [
                                "nasIp" => $mkIp,
                                "activeUsers" => []
                            ];

                            $currentActiveUsers = [];
                            foreach ($allActiveUsers as $user) {

                                $currentActiveUsers[$user["name"]] = $user;
                            }

                            // return $clients;
                            foreach ($clients as $client) {
                                if (array_key_exists($client->userid, $currentActiveUsers)) {
                                    array_push($mikrotikAndActiveUsers["activeUsers"], $currentActiveUsers[$client->userid]);
                                    $count++;
                                    $new_client[$client->userid] = $client->id;
                                }
                            }
                            // return $mikrotikAndActiveUsers;
                            array_push($allMikrotikAndActiveUsers, $mikrotikAndActiveUsers);
                        } catch (Exception $err) {
                        }
                    }
                } else if ($request->reseller == null) {
                    $allMikrotik = Nas::all();


                    foreach ($allMikrotik as $mikrotik) {
                        try {

                            $mkIp = $mikrotik->nasname;
                            $mkUsername = $mikrotik->mikrotick_user;
                            $mkPassword = $mikrotik->mikrotick_user_password;
                            $mkPort = $mikrotik->mikrotick_port;
                            $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
                            $allActiveUsers = $mk->getActiveConnection();

                            $mikrotikAndActiveUsers = [
                                "nasIp" => $mkIp,
                                "activeUsers" => []
                            ];

                            $currentActiveUsers = [];
                            foreach ($allActiveUsers as $user) {

                                $currentActiveUsers[$user["name"]] = $user;
                            }
                            $clients = Client::list()->whereIn("userid", array_keys($currentActiveUsers))->get();

                            foreach ($clients as $client) {
                                if (array_key_exists($client->userid, $currentActiveUsers)) {
                                    array_push($mikrotikAndActiveUsers["activeUsers"], $currentActiveUsers[$client->userid]);
                                    $count++;
                                    $new_client[$client->userid] = $client->id;
                                }
                            }

                            array_push($allMikrotikAndActiveUsers, $mikrotikAndActiveUsers);
                        } catch (Exception $err) {
                        }
                    }
                }
                // dd($allMikrotikAndActiveUsers);
                $data = [

                    'allMikrotikAndActiveUsers' => $allMikrotikAndActiveUsers,
                    'page_title' => 'Online Customer List',
                    "count" => $count,
                    'clients' => $new_client,
                ];
                // return $data;
                return view('clients.onlineofline.onlinesearch', $data);
            }
        } else {
            if ($request->ajax()) {

                $list = Client::list()->where('clients_status', '!=', 'deactive');

                if ($request->reseller != null && $request->pop == 'all') {

                    $reseller_ids = DB::table('reseller_user')->where('reseller_id', $request->reseller)->pluck('reseller_id')->toArray();
                    $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();
                    $list = $list->whereIn('pop_id', $pop_ids)->pluck('userid')->toArray();
                } elseif ($request->reseller != null && $request->pop != null) {

                    $list = $list->where('pop_id', $request->pop)->pluck('userid')->toArray();
                } elseif ($request->reseller == null) {

                    $list = $this->customer_list();
                }
            }

            // $online = DB::table('radacct')
            //     ->select('radacctid', 'username', 'nasipaddress', 'nasporttype', 'acctstarttime', 'acctupdatetime', 'callingstationid', 'framedipaddress', 'acctterminatecause')
            //     ->whereNull('acctstoptime')
            //     ->whereIn('username', $list)
            //     ->orderBy('radacctid', 'desc')
            //     // ->paginate(5000);
            //     ->get();

                $listChunks = array_chunk($list, 1000);
                $online = collect(); // Initialize an empty collection to store the results

                foreach ($listChunks as $chunk) {
                    $result = DB::table('radacct')
                        ->select('radacctid', 'username', 'nasipaddress', 'nasporttype', 'acctstarttime', 'acctupdatetime', 'callingstationid', 'framedipaddress', 'acctterminatecause')
                        ->whereNull('acctstoptime')
                        ->whereIn('username', $chunk)
                        ->orderBy('radacctid', 'desc')
                        ->get();

                    $online = $online->merge($result);

                    // Process $result as needed
                }
            // dd($online);

            session([
                'onlineUserList' => $online
            ]);

            return view('clients.onlineofline.onlinesearch', [
                'list' => $online,
                'page_title' => 'Online Customer List',
            ]);
        }
    }

    public function disconnectAll()
    {
        $list = session('onlineUserList');

        foreach ($list as $l) {

            $this->disconnect($l->radacctid);
            DB::table('radacct')->where('username', $l->username)->update(['acctstoptime' => now()]);
        }
        return redirect()->back();
    }


    public function disconnect($id)
    {
        $userinfo = DB::table('radacct')->where('radacctid', $id)->first();

        $nas = DB::table('nas')->where('nasname', $userinfo->nasipaddress)->first();


        if ($nas) {
            $result = exec('echo "User-Name=' . $userinfo->username . '" | radclient ' . $nas->nasname . ':3799 "disconnect" ' . $nas->secret);
        } else {

            $client = Client::with('pop', 'pop.nas')->where('userid', $userinfo->username)->first();
            $result = exec('echo "User-Name=' . $client->userid . '" | radclient ' . $client->pop->nas->nasname . ':3799 "disconnect" ' .
                $client->pop->nas->secret);
        }



        if (!empty($result)) {

            DB::table('radacct')->where('username', $userinfo->username)->update(['acctstoptime' => now()]);

            Toastr::success($result, 'success');
        } else {

            Toastr::error('something is wrong', 'error');
        }
    }

    public function onlineUserDisconnect(Request $request)
    {
        $this->disconnect($request->id);
        return redirect()->back();
    }
}
