<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\Client;
use App\Models\CustomerAccount;
use App\Models\Packages;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class OpenPaymentController extends Controller
{

    public function index()
    {
        //
    }

    public function openPayment($token)
    {
        $customer_info = Client::with(['clientsinfo', 'pop'])->where('slug', $token)->first();

        if ($customer_info != null) {
            $id                     = $customer_info->id;
            $details['userinfo']    =  $customer_info;
            $details['paymentinfo'] = Billpayment::whereClient_id($id)->get();
            $details['billinginfo'] = BillGenerate::whereClient_id($id)->get();
            $details['package']     = Packages::where('id', $customer_info->package_id)->first();
            $details['account']     = CustomerAccount::firstOrCreate(['client_id' => $id]);
            $bill_amount = 0;

            if ($details['account']->dueAmount > 0) {
                $bill_amount = $details['account']->dueAmount;
            } else {
                $bill_amount = $details['package']->package_rate + $details['account']->dueAmount;
            }

            $payment_btns = collect(json_decode(siteinfo()->payment_button));

            return view('Customer.client-payment-slug', [
                'page_title' => 'Pay Now',
                'details' => $details,
                'buttons' => $payment_btns,
                'bill_amount' => $bill_amount
            ]);
        } else {
            return redirect()->route('customer_login');
        }
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
