<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Client;
use App\Models\Balance;
use App\Models\Packages;
use App\Classes\MikrotikService\Mikrotik;
use App\Classes\MikrotikService\SyncWithMk;
use App\Classes\SMS\ResellerRechargeSms;
use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Models\SubPackage;
use Illuminate\Http\Request;
use App\Models\CustomerAccount;
use App\Services\PriceCalculate;
use Illuminate\Support\Facades\DB;
use App\Services\CommissionService;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use App\Models\ReselleBalanceLogReport;
use App\Models\ResellerSmsGetway;
use App\Models\SubResellerBalanceLogReport;

class CustomerRechargeController extends Controller
{
    //

    public function CustomerRecharge(Request $request)
    {
        // dd($request->all());
        if (Auth::user()->hasPermissionTo('dynamic-recharge')) {
            if (checkSettings('reseller-client-dynamic-recharge') == 'enable') {
                if ($request->dynamic_recharge == 'yes' && !empty($request->ids) && $request->type == 'Recharge') {
                    $result = (new DynamicRechargeController)->dynamicRechargeProcess($request);
                    if ($result['status'] == 'success') {
                        return [
                            'status' => 'success',
                            'message' => 'All Recharge Done...'
                        ];
                    } else {
                        // dd($result);
                        return [
                            'status' => 'error',
                            'message' => $result['status']
                        ];
                    }
                }
            } else {
                Toastr::error('Dynamic Recharge is not enable', 'Error');
            }
        } else {
            if ($request->type == 'Recharge' && !empty($request->ids)) {
                try {
                    DB::beginTransaction();
                    foreach ($request->ids as $id) {
                        $st = $this->doCustomerRecharge($id);
                        if ($st == 'balance_error') {
                            return [
                                'status' => 'balance_error',
                                'message' => 'Insufficient Balance'
                            ];
                        } elseif ($st == 'sub_package_error') {
                            return [
                                'status' => 'sub_package_error',
                                'message' => 'There is not Sub Package'
                            ];
                        }
                    }
                    DB::commit();
                    Toastr::success('Recharge Done..', 'Success');
                    try {

                        $this->resellerCustomerRechargeSms($request);
                    } catch (\Exception $e) {
                    }
                    return [
                        'status' => 'success',
                        'message' => 'All Recharge Done..'
                    ];
                } catch (\Throwable $th) {
                    DB::rollBack();
                    return [
                        'status' => 'error',
                        'message' => $th
                    ];
                }
            } elseif ($request->type == 'billingCycleChange' && !empty($request->ids)) {
                $this->doBillingCycleChange($request);
            } else {
                return [
                    'status' => 'error',
                    'message' => 'Invalid users or did not select recharge'
                ];
            }
        }
    }

    public function resellerCustomerRechargeSms($request)
    {

        foreach ($request->ids as $id) {
            $reseller_recharge = new ResellerRechargeSms();
            $reseller_recharge->send($id);

            $client = Client::with('pop', 'clientsinfo', 'packages')->find($id);
            $reseller_sme_getway = ResellerSmsGetway::with('reseller')->where('reseller_id', $client->pop->reseller_id)->first();
            // dd($reseller_sme_getway);
            if ($reseller_sme_getway) {
                $customer_recharge = collect(json_decode($reseller_sme_getway->sms_formate))->where('sms_type', 'other_reseller_customer_recharge')->first();
                if ($customer_recharge->send_sms == "Yes") {

                    (new ResellerRechargeSms())->sendOtherResellerCustomerRechargeSms(
                        $client,
                        $reseller_sme_getway->sms_gateway,
                        $reseller_sme_getway->reseller->name,
                        $reseller_sme_getway->reseller->contact,
                        $customer_recharge->sms_body,
                        $reseller_sme_getway->reseller->id
                    );
                }
            }
        }
    }


    public function doCustomerRecharge($id)
    {


        $user = Client::find($id);
        $pop  = Pop::find($user->pop_id);
        if ($pop->bill_generate == 'yes') {
            return false;
        }

        $package          = Packages::find($user->package_id);
        $resellerBalance  = Balance::getBalance('reseller', $pop->reseller_id);


        $expire = Carbon::parse($user->expire_date);

        if (checkSettings('recharge_expire_customer_today') == 'enable') {
            if ($expire < today()) {
                $cur = today();

                $generateDate =  Carbon::parse(date('Y-m-' . $user->billing_cycle));

                if (date('t') < $user->billing_cycle) {
                    $user->billing_cycle = date('t');
                    $user->save();
                }

                $nextExpire                 = date('d') > $user->billing_cycle ? Carbon::parse(date('Y-m-' . $user->billing_cycle))->addMonth() : Carbon::parse(date('Y-m-' . $user->billing_cycle));


                $totalDay                   = $nextExpire->diffInDays($cur) + 1;
                $action_days_message        = 'Total ' . $totalDay . ' days. From ' . $cur . ' To ' . $nextExpire;

                $totalCost                  = PriceCalculate::calculate(today()->daysInMonth, $package->package_rate, $totalDay);
            } else {
                $nextExpire = Carbon::parse($user->expire_date)->addMonth();
                $totalCost = $package->package_rate;
                $action_days_message = ' 1 Month. From ' . $user->expire_date . ' To ' . $nextExpire;
            }
        } else {
            if ($expire < today() && Carbon::parse($user->expire_date)->addMonth() < today()) {


                $cur = today();

                $generateDate =  Carbon::parse(date('Y-m-' . $user->billing_cycle));

                if (date('t') < $user->billing_cycle) {
                    $user->billing_cycle = date('t');
                    $user->save();
                }

                $nextExpire                 = date('d') > $user->billing_cycle ? Carbon::parse(date('Y-m-' . $user->billing_cycle))->addMonth() : Carbon::parse(date('Y-m-' . $user->billing_cycle));


                $totalDay                   = $nextExpire->diffInDays($cur) + 1;
                $action_days_message        = 'Total ' . $totalDay . ' days. From ' . $cur . ' To ' . $nextExpire;

                $totalCost                  = PriceCalculate::calculate(today()->daysInMonth, $package->package_rate, $totalDay);
                // $totalCost                  = ($package->package_rate/today()->daysInMonth)*$totalDay;


            } else {
                $nextExpire = Carbon::parse($user->expire_date)->addMonth();
                $totalCost = $package->package_rate;
                $action_days_message = ' 1 Month. From ' . $user->expire_date . ' To ' . $nextExpire;
            }
        }




        $reseller_id      = $pop->reseller_id;





        if ($resellerBalance >= $totalCost) {

            if ($pop->billable == 'yes') {

                Balance::balanceDeductForUserRecharge('reseller', $reseller_id, $totalCost);

                if ($pop->subreseller == 'yes') {

                    $subPackage = SubPackage::find($user->sub_package_id);
                    $popBalance  = Balance::getBalance('pop', $pop->id);

                    // dd($subPackage);

                    if (empty($subPackage)) {
                        return 'sub_package_error';
                    }

                    if (checkSettings('recharge_expire_customer_today') == 'enable') {
                        if ($expire < today()) {
                            $subTotalCost = PriceCalculate::calculate(today()->daysInMonth, $subPackage->rate, $totalDay);
                        } else {
                            $subTotalCost = $subPackage->rate;
                        }
                    } else {
                        if ($expire < today() && Carbon::parse($user->expire_date)->addMonth() < today()) {
                            // $subTotalCost = ($subPackage->rate/today()->daysInMonth)*$totalDay;
                            $subTotalCost = PriceCalculate::calculate(today()->daysInMonth, $subPackage->rate, $totalDay);
                        } else {
                            $subTotalCost = $subPackage->rate;
                        }
                    }



                    if ($subTotalCost > $popBalance) {

                        return 'balance_error';
                    }



                    $SubResellerAction = "Recharge For " . $action_days_message .
                        " . For package " . $subPackage->name .
                        " cost BDT " . $subTotalCost;

                    Balance::balanceDeductForUserRecharge('pop', $pop->id, $subTotalCost);

                    if ($subPackage->commission > 0) {
                        (new CommissionService())->subreseller_commission($subTotalCost, $SubResellerAction, $pop->id, $subPackage->commission, $subPackage->rate, $user->id);
                    }

                    SubResellerBalanceLogReport::create(
                        [
                            'reseller_id'       => $reseller_id,
                            'sub_reseller_id'   => $pop->id,
                            'client_id'         => $id,
                            'action'            => $SubResellerAction,
                            'amount'            => $subTotalCost,
                            'remarks'           => 'Created BY ' . Auth::user()->email
                        ]
                    );
                }
            }



            $action = "Recharge For " . $action_days_message .
                " . For package " . $package->package_name .
                " cost BDT " . $totalCost;


            // Balance::balanceDeductForUserRecharge('reseller', $reseller_id, $totalCost);
            ReselleBalanceLogReport::create(
                [
                    'reseller_id' => $reseller_id,
                    'client_id'   => $id,
                    'action'      => $action,
                    'amount'      => $totalCost,
                    'remarks'     => 'Created BY ' . Auth::user()->email
                ]
            );
            if ($package->commission > 0) {
                (new CommissionService())->reseller_commission($totalCost, $action, $reseller_id, $package->commission, $package->package_rate, $user->id);
            }



            if ($pop->bill_generate == 'yes') {

                CustomerAccount::updateCustomrAccount($id, $package->package_rate, 0, 0, $totalCost);
                BillGenerateController::entryBillGenerate($id, $totalCost, 'Customer Recharge', 'recharge', $nextExpire);
            }


            $client = Client::with("pop.nas", 'packages')->find($user->id);
            $client->expire_date    = $nextExpire;
            $client->clients_status = 'active';
            $client->save();


            if (checkAPI()) {
                $mk = new SyncWithMk();
                $mk->syncSingleClient($client->id);
            } else {

                (new IdEnableDisableController)->enableInRadius($client);

                // DB::table('radcheck')
                //     ->where('username', '=', $user->userid)
                //     ->update([
                //         'op' => ':='
                //     ]);
            }
        } else {
            return 'balance_error';
        }
    }


    public function doBillingCycleChange($request)
    {
        # code...
    }





    public function recharge($r)
    {
        $user = Client::find($r->recharge);



        $now = Carbon::now();
        $expire = Carbon::parse($user->expire_date);
        echo $now;
        echo '<br>';
        echo $user->expire_date;
        echo '<br>';

        $month = $now->diffInMonths($expire);

        echo $month . "<br>";


        if ($month > 0 && $expire > $now) {
            $expire = $now;
            $next = Carbon::parse(date($user->billing_cycle . '-M-Y'));
            $totalDay = $next->diffInDays($expire);
        } else {
            $expire = $expire;
            $next = Carbon::parse($expire)->addMonth();
            $totalDay = $next->diffInDays($expire);
        }

        // if($month < 1 && $now > $expire){

        //   $expire = $expire;
        //   $next = Carbon::parse($expire)->addMonth();
        //   $totalDay = $next->diffInDays($expire);

        // }elseif($month < 1 && $now < $expire ){

        //   $expire = $expire;
        //   $next = Carbon::parse($expire)->addMonth();
        //   $totalDay = $next->diffInDays($expire);

        // }else{
        //   $expire = $now;
        //   $next = Carbon::parse(date($user->billing_cycle.'-M-Y'));
        //   $totalDay = $next->diffInDays($expire);

        // }


        // echo $totalDay;
        // echo '<br>';
        // echo $next;
        // dd();

        $pop              = Pop::find($user->pop_id);
        $package          = Packages::find($user->package_id);
        $resellerBalance  = $this->getResellerBalance('reseller', $pop->reseller_id);
        $totalCost        = $package->package_rate;



        if ($resellerBalance > $totalCost) {


            $reseller_id = $pop->reseller_id;


            $action = "Recharge For 1 Month. From Date: " . $expire .
                " To : " . $next .
                " . For package " . $package->package_name .
                " Total " . $totalDay .
                " days cost BDT " . $totalCost;


            Client::where('id', $user->id)
                ->update(
                    [
                        'expire_date'  => Carbon::createFromFormat('Y-m-d H:i:s', $next)
                    ]
                );

            ReselleBalanceLogReport::create(
                [
                    'reseller_id' => $reseller_id,
                    'client_id'   => $user->id,
                    'action'      => $action,
                    'amount'      => $totalCost,
                    'remarks'     => ' BY ' . Auth::user()->email
                ]
            );
            Balance::balanceDeductForUserRecharge('reseller', $reseller_id, $totalCost);
            $this->clientExpire($user->id);
            $this->activeRadcheck($user->userid);

            return 'success';
        } else {
            return 'error';
        }
    }


    public function clientInfoData($id)
    {
        $client = Client::find($id);
        $expire_bd = Carbon::parse($client->expire_date)->format('d-M-Y');
        $expire_pd = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('d-M-Y');
        return response()->json([
            'expire_bd'       => $expire_bd,
            'expire_pd'       => $expire_pd,

        ]);
    }
}
