<?php

namespace App\Http\Controllers;

use App\Models\District;
use App\Models\Upazila;
use Illuminate\Http\Request;

class DivisionDistrictThanaController extends Controller
{
    public function fetchDistrict(Request $request)
    {
        $districts = District::where('division_id', $request->id)->orderBy('name', 'ASC')->get();

        $option = '<option selected disabled hidden value=""> Select one</option>';
        foreach ($districts as $row) {
            $option = $option . '<option value="' . $row->id . '">' . $row->name . '-' . $row->bn_name . '</option>';
        }

        return response()->json($option);
    }

    public function fetchThana(Request $request)
    {
        $upazilas = Upazila::where('district_id', $request->id)->orderBy('name', 'ASC')->get();

        $option = '<option selected disabled hidden value=""> Select one</option>';
        foreach ($upazilas as $row) {
            $option = $option . '<option value="' . $row->id . '">' . $row->name . '-' . $row->bn_name . '</option>';
        }

        return response()->json($option);
    }
}
