<?php

namespace App\Http\Controllers;

use App\Models\Pop;
use App\Models\Client;
use Illuminate\Http\Request;
use App\Jobs\BillGenerateJob;
use App\Jobs\ApiClientExpireJob;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\SessionRefreshController;
use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Jobs\ExpireRadiusUserJob;
use Exception;
use Illuminate\Support\Facades\Log;
use Pusher\Pusher;

class ExpireCheckController extends Controller
{

    static function checkAdvanced()
    {

        $bill_month = null;

        Client::with('packages')
            ->select('clients.id', 'clients.expire_date', 'clients.package_id', 'clients.parmanent_discount', 'customer_accounts.dueAmount', 'packages.package_rate')
            ->join('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
            ->join('packages', 'clients.package_id', '=', 'packages.id')
            ->where('customer_accounts.dueAmount', '<', 0)
            ->where('clients.clients_status', '!=', 'deactive')
            ->whereRaw('packages.package_rate <= ABS(customer_accounts.dueAmount - clients.parmanent_discount)')
            ->orderBy('clients.id', 'asc')
            ->chunk(100, function ($clients) use ($bill_month) {
                // dd($clients->count());
                BillGenerateJob::dispatch($clients, $bill_month);
            });
    }

    static function check($time = '00:00:00')
    {
       

        echo $time;

        DB::table('clients')
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->whereRaw("ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)")
            ->update([
                'clients_status' => 'expired'
            ]);





        DB::table('radcheck')
            // ->select('username')
            ->whereRaw("username IN (SELECT userid FROM clients WHERE ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)  AND pop_id IN (SELECT id FROM pops where experity_check = 'No'))")
            // ->get();
            ->update([
                'op' => '!='
            ]);

        $lists = DB::table('radcheck')
            ->select('username')
            ->whereRaw("username IN (SELECT userid FROM clients WHERE ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)  AND pop_id IN (SELECT id FROM pops where experity_check = 'No'))")
            ->distinct()
            ->pluck('username')
            ->toArray();

        $dlist = DB::table('clients')->where('clients_status', 'deactive')->orWhere('clients_status', 'disable')->pluck('userid')->toArray();

        DB::table('radcheck')
            ->whereIn('username', $dlist)
            ->update([
                'op' => '!='
            ]);

        $info = json_encode($lists);
        DB::table('check_expire')->insert([
            'info' => $info
        ]);


        // $online_lists = DB::table('radacct')
        //     ->select('username')
        //     ->where('acctstoptime')
        //     ->whereIn('username', $lists)
        //     ->pluck('username')->toArray();

        // foreach ($online_lists as $l) {

        //     SessionRefreshController::userDisconnectProcess($l);
        // }
        $count = 0;
        $expire_user = [];
        foreach ($lists as $l) {
            echo $l . "\n";

            // array_push($expire_user, $l);
            // $count++;
            // if($count == 15){
            //     ExpireRadiusUserJob::dispatch($expire_user);
            //     $count = 0;
            //     $expire_user = [];
            // }

            try {
                SessionRefreshController::userDisconnectProcess($l);
            } catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }

        // ExpireRadiusUserJob::dispatch($expire_user);
        // $count = 0;
        // $expire_user = [];


        foreach ($dlist as $l) {
            // array_push($expire_user, $l);
            // $count++;
            // if($count == 100){
            //     ExpireRadiusUserJob::dispatch($expire_user);
            //     $count = 0;
            //     $expire_user = [];
            // }
            try {
                SessionRefreshController::userDisconnectProcess($l);
            } catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }

        // ExpireRadiusUserJob::dispatch($expire_user);
        // $count = 0;
        // $expire_user = [];

    }


    static function check_backup()
    {

        echo 'expire check start';



        $exception_pop_list = Pop::where('experity_check', 'Yes')->pluck('id')->toArray();

        $lists = Client::whereIn('pop_id', $exception_pop_list)
            ->where('expire_date', '<', today())
            ->where(function ($q) {
                $q->where('clients_status', '!=', 'deactive')
                    ->where('clients_status', '!=', 'disable');
            })
            ->pluck('userid')
            ->toArray();


        DB::table('clients')
            ->whereIn('userid', $lists)
            ->update([
                'clients_status' => 'expired'
            ]);


        $pop_list = Pop::where('experity_check', 'No')->pluck('id')->toArray();

        Client::where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->where('expire_date', '<', today())
            ->whereIn('userid', $pop_list)
            ->update(['clients_status' => 'expired']);


        $lists = Client::whereIn('pop_id', $pop_list)
            ->where('expire_date', '<', today())
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->pluck('userid')
            ->toArray();


        $info = json_encode($lists);

        DB::table('clients')
            ->whereIn('userid', $lists)
            ->update([
                'clients_status' => 'expired'
            ]);

        DB::table('radcheck')
            ->whereIn('username', $lists)
            ->update([
                'op' => '!='
            ]);

        foreach ($lists as $l) {
            SessionRefreshController::userDisconnectProcess($l);
        }

        DB::table('check_expire')->insert([
            'info' => $info
        ]);

        echo 'expire check end';

        // disable and deactive customer fix
        $lists = Client::where('clients_status', 'deactive')
            ->where('clients_status', 'disable')
            ->pluck('userid')
            ->toArray();


        DB::table('radcheck')
            ->whereIn('username', $lists)
            ->update([
                'op' => '!='
            ]);

        foreach ($lists as $l) {
            SessionRefreshController::userDisconnectProcess($l);
        }

        DB::table('check_expire')->insert([
            'info' => $info
        ]);

        echo 'expire check end';
    }




    static public function recheck()
    {
        echo 'recheck start';

        $lists = Client::with('pop', 'pop.nas')
            ->whereRaw('DATE_ADD(expire_date,INTERVAL payment_dadeline DAY) >= CURDATE()')
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->get();


        if (checkAPI()) {


            $list_array = $lists->pluck('userid')->toArray();
            DB::table('clients')
                ->whereIn('userid', $list_array)
                ->update([
                    'clients_status' => 'active'
                ]);

            // foreach ($lists as $l) {
            //     if ($l->pop) {

            //         (new IdEnableDisableController)->activeUserInMikrotik($l);
            //     }
            // }
        } else {

            $lists = $lists->pluck('userid')->toArray();
            DB::table('clients')
                ->whereIn('userid', $lists)
                ->update([
                    'clients_status' => 'active'
                ]);

            DB::table('radcheck')
                ->whereIn('username', $lists)
                ->update([
                    'op' => ':='
                ]);
        }




        echo '<br>recheck end';
    }




    static public function api_expair_check($time)
    {



        $expire_customers =   DB::table('clients')
            ->whereNull('deleted_at')
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->whereRaw("ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)")
            ->whereRaw("pop_id IN (SELECT id FROM pops where experity_check = 'No')")
            ->select('id', 'userid', 'pop_id')
            ->get()
            ->groupBy('pop_id')
            ->toArray();

        $expire_customers_id = DB::table('clients')
            ->whereNull('deleted_at')
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->whereRaw("ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)")
            ->whereRaw("pop_id IN (SELECT id FROM pops where experity_check = 'No')")
            ->pluck('id')
            ->toArray();

        DB::beginTransaction();
        try {
            Client::whereIn('id', $expire_customers_id)->update(["clients_status" => "expired"]);
            DB::commit();
        } catch (Exception $err) {
            DB::rollBack();
        }



        // deprecated: gonna delete this shortly. 
        // foreach ($expire_customers as $expire) {

        //     $new_list = array_chunk($expire, 100);

        //     foreach ($new_list as $l) {
        //         ApiClientExpireJob::dispatch($l);
        //     }
        // }

        $info = json_encode($expire_customers);
        DB::table('check_expire')->insert([
            'info' => $info
        ]);


        DB::table('clients')
            ->whereNull('deleted_at')
            ->where('clients_status', '!=', 'deactive')
            ->where('clients_status', '!=', 'disable')
            ->whereRaw("ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)")
            ->whereRaw("pop_id IN (SELECT id FROM pops where experity_check = 'Yes')")
            ->update([
                'clients_status' => 'expired'
            ]);
    }

    static public function disconnectExpireButOnline($time)
    {
        $lists = DB::table('radcheck')
            ->select('username')
            ->whereRaw("username IN (SELECT userid FROM clients WHERE ADDTIME(DATE_ADD(expire_date,INTERVAL payment_dadeline DAY), '$time') < SUBDATE(NOW(),INTERVAL 1 DAY)  AND pop_id IN (SELECT id FROM pops where experity_check = 'No'))")
            ->distinct()
            ->pluck('username')
            ->toArray();

        $l = DB::table('radacct')->whereNull('acctstoptime')->whereIn('username', $lists)->get();

        foreach ($l as $key => $value) {
            echo $value->username . "\n";
            SessionRefreshController::userDisconnectProcess($value->username);
        }
    }
}
