<?php

namespace App\Http\Controllers;

use App\Models\BillGenerate;
use App\Models\Billpayment;
use App\Models\Client;
use App\Models\CustomerAccount;
use App\Models\Permission;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class FixCommonIssueController extends Controller
{

    public function fixRokibulViName()
    {
        $user = User::where('email', 'rokibulhasan.356@gmail.com')->first();
        $user->name = 'System';
        $user->save();
    }

    public function changePermissionName()
    {
        $permission = Permission::where('name', 'change-package-without-cost')->first();
        if ($permission) {
            $permission->name = 'batch-package-change-without-cost';
            $permission->save();
        }
    }

    public function fixedDuplicateMoneyReceiptNumber()
    {


        $duplicateReceiptNumbers = Billpayment::groupBy('money_receipt_number')
            ->havingRaw('COUNT(*) > 1')
            ->get();
        // dd($duplicateReceiptNumbers->count());
        foreach ($duplicateReceiptNumbers as $duplicateReceiptNumber) {
            $billPayments = Billpayment::where('money_receipt_number', $duplicateReceiptNumber->money_receipt_number)->get();
            $count = 0;
            foreach ($billPayments as $billPayment) {
                $count++;
                if ($count > 1) {

                    // $billPayment->money_receipt_number = $billPayment->money_receipt_number . '-' . $count;
                    // $billPayment->save();
                    DB::table('bill_payments')
                        ->where('id', $billPayment->id) // Assuming 'id' is the primary key column
                        ->update([
                            'money_receipt_number' => DB::raw("CONCAT(money_receipt_number, '-$count')")
                        ]);
                }
            }
        }
    }

    public function setAllPermanentDiscountNullValueToZero()
    {
        DB::table('clients')
            ->whereNull('parmanent_discount')
            ->update(['parmanent_discount' => 0]);
    }

    public function deletePreviousMonthBIllForDeActiveCustomer()
    {
        $clients = Client::with('customerAccount', 'packages')->where('client_approval', 'approved')->where('clients_status', 'deactive')->get();
        $allClient = [];
        foreach ($clients as $client) {
            if (isset($client->customerAccount)) {
                $due = $client->customerAccount->dueAmount ?? 0;
                if ($due >= $client->packages->package_rate) {
                    array_push($allClient, $client->id);
                    $start = today()->subMonth()->firstOfMonth()->format('Y-m-d 00:00:00');
                    $end = today()->subMonth()->endOfMonth()->format('Y-m-d 23:59:59');
                    // dd($start,$end);

                    $bill =  BillGenerate::where('client_id', $client->id)
                        ->whereBetween('created_at', [$start, $end])
                        ->where('billing_type', 'monthly')
                        ->first();

                    if ($bill) {
                        DB::beginTransaction();
                        try {
                            $clientAccount = CustomerAccount::where('client_id', $bill->client_id)->first();

                            $clientAccount->decrement('dueAmount', $bill->bill_amount);
                            $clientAccount->decrement('totalBillAmount', $bill->bill_amount);

                            $description = $bill->billing_type . ' bill deleted: ' . $bill->bill_amount;
                            $bill->description = $description . ' | Previous description : ' . $bill->description;
                            $bill->bill_amount = 0;
                            $bill->paid_amount = 0;
                            $bill->parmanent_discount = 0;
                            $bill->billing_type = 'deleted';
                            $bill->deleted_at = Carbon::now();
                            $bill->deleted_by = auth()->user()->id ?? 1;
                            $bill->save();
                            DB::commit();
                        } catch (\Exception $e) {
                            dd($e);
                        }
                    }
                }
            } else {
                // dd($client->toArray());
            }
        }

        // dd($allClient);
    }

    public function addCustomerAccountIfNotExit()
    {
        $clients = Client::with('pops')->where('client_approval', 'approved')->get();

        foreach ($clients as $client) {
            // dd($client->reseller, $client);
            if ($client->pops->billable == 'yes') {
                $checkCustomerAccount = CustomerAccount::where('client_id', $client->id)->get()->count();
                if ($checkCustomerAccount <= 0) {
                    CustomerAccount::create([
                        'client_id'       => $client->id,
                        'totalPaid'       => 0,
                        'dueAmount'       => 0,
                        'totalDiscount'   => 0,
                        'totalBillAmount' => 0
                    ]);
                }
            }
        }
    }
}
