<?php

namespace App\Http\Controllers;

use App\Classes\BillgenerateUpdate;
use App\Models\PayBillLog;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PayBillLogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(auth()->user()->id != 1){
            Toastr::error('You are not authorized to access this page');
            return redirect()->back();
        }
        $start= today()->subDay(10);
        $end = today()->endOfDay();
        $logs = PayBillLog::whereBetween('created_at',[$start,$end])->get();
        // dd("comes");

        $data = [
            'start' => $start,
            'end' => $end,
            'logs' => $logs
        ];
        return view('payBillLog.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if(auth()->user()->id != 1){
            Toastr::error('You are not authorized to access this page');
            return redirect()->back();
        }
       if($request->from_date && $request->to_date){
            $start= Carbon::parse($request->from_date)->format('Y-m-d  00:00:00');
            $end = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');
            $logs = PayBillLog::whereBetween('created_at',[$start,$end])->get();
            // dd("comes");

            $data = [
                'start' => $start,
                'end' => $end,
                'logs' => $logs
            ];
            return view('payBillLog.index', $data);
       }
       Toastr::error('Please Select Date Range');
         return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PayBillLog  $payBillLog
     * @return \Illuminate\Http\Response
     */
    public function show(PayBillLog $payBillLog)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PayBillLog  $payBillLog
     * @return \Illuminate\Http\Response
     */
    public function edit(PayBillLog $payBillLog)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PayBillLog  $payBillLog
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PayBillLog $payBillLog)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PayBillLog  $payBillLog
     * @return \Illuminate\Http\Response
     */
    public function destroy(PayBillLog $payBillLog)
    {
        //
    }

    public function check()
    {
        // (new BillgenerateUpdate())->update(59581);
        // dd("comes");
        (new BillgenerateUpdate)->update(1);
        // dd("comes");
        return redirect()->back();
    }
}
