<?php

namespace App\Http\Controllers;

use App\Jobs\MigrateRadiusLog;
use App\Jobs\StoreClientDownLoadUploadJob;
use App\Jobs\UserRedcheckUpdateJob;
use App\Models\ApiBandwidthUsage;
use App\Models\Client;
use App\Models\RadiusLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class RadiusLogController extends Controller
{
    public function migrateRadiusLogSecondDataBase()
    {

        $clients = Client::get();

        foreach($clients as $client){
            $logs = DB::table('radacct')->select([
                "acctuniqueid", "username",
                "nasipaddress", "callingstationid",
                "acctinputoctets", "acctoutputoctets",
                "acctstarttime", "acctstoptime",
                "acctterminatecause"
            ])->where('username',$client->userid)->get();

            $logs = $logs->groupBy('username');

            MigrateRadiusLog::dispatch($logs)->onQueue('user_log_queue');
        }

        $logs = DB::table('radacct')->select([
            "acctuniqueid", "username",
            "nasipaddress", "callingstationid",
            "acctinputoctets", "acctoutputoctets",
            "acctstarttime", "acctstoptime",
            "acctterminatecause"
        ])->get();



        $groupedLogs = $logs->groupBy('username');

        $groupedLogs->chunk(100)->each(function ($chunkUsersLogs) {
            MigrateRadiusLog::dispatch($chunkUsersLogs)->onQueue('user_log_queue');
        });
    }

    public function migrateRadiusLog($chunkUsersLogs)
    {
        foreach ($chunkUsersLogs as $logs) {
            $count = $logs->count();
            if ($count <= 3) {
                continue;
            }

            $orderedLog = $logs->sortByDesc("acctstarttime")->skip(2);

            $logsInfo = $orderedLog->toArray();
            $allIds = $orderedLog->pluck('acctuniqueid')->toArray();

            $preparedData = $this->prepareLogForInsert($logsInfo);
            RadiusLog::insert($preparedData);
            DB::table('radacct')->whereIn('acctuniqueid', $allIds)->delete();
        }
    }

    public function prepareLogForInsert($logs)
    {
        $all = [];
        foreach ($logs as $log) {
            $radius_log = [];
            $radius_log["session_id"] = $log->acctuniqueid;
            $radius_log["username"] = $log->username;
            $radius_log["ip_address"] = $log->nasipaddress;
            $radius_log["mac_address"] = $log->callingstationid ?? null;
            $radius_log["uploaded"] = $log->acctinputoctets / 1048576;
            $radius_log["downloaded"] = $log->acctoutputoctets / 1048576;
            $radius_log["session_start_time"] = $log->acctstarttime;
            $radius_log["session_end_time"] = $log->acctstoptime ?? null;
            $radius_log["last_disconnect_reason"] = $log->acctterminatecause ?? null;
            $radius_log["created_at"] = now();
            $radius_log["updated_at"] = now();
            $all[] = $radius_log;
        }
        return $all;
    }

    public function userUpdate()
    {
        // dd("user update");
        $list = DB::table('clients')
            ->leftJoin('pops', 'pops.id', '=', 'clients.pop_id')
            ->leftJoin('nas', 'nas.id', '=', 'pops.nas_id')
            ->select('clients.userid', 'clients.password', 'nas.nasname', 'clients.clients_status', 'clients.deleted_at')
            ->OrderbY('clients.id')->chunk(1000, function ($lists) {
                UserRedcheckUpdateJob::dispatch($lists);
            });
    }

    public function getCustomerLogHistory($client_id)
    {
        $currentDate = today()->endOfDay();



        $client = Client::withTrashed()->where('id', $client_id)->first();
        $id = $client->userid;

        if ($currentDate->day < $client->billing_cycle) {
            $prevExpDate = Carbon::createFromDate(today()->year, today()->month, $client->billing_cycle)->subMonth()->endOfDay();
        } else {
            $prevExpDate = Carbon::createFromDate(today()->year, today()->month, $client->billing_cycle)->endOfDay();
        }

        $start = $prevExpDate;
        $end = $currentDate;



        if (!checkAPI()) {

            $list = DB::table('radacct')
                ->select('*')
                ->where('username', $id)
                ->whereDate('acctstarttime', '>', $prevExpDate)
                ->orderBy('acctstarttime', 'desc')
                ->get();
            $list_2 = [];
            if(checkSettings('connect_second_data_base') == "enable"){

                $list_2 = RadiusLog::where('username', $id)
                    ->whereBetween('session_start_time', [Carbon::parse($prevExpDate)->format('Y-m-d 00:00:00'), Carbon::parse($currentDate)->format('Y-m-d 00:00:00')])
                    ->orderBy('session_start_time', 'desc')
                    ->get();
            }

            return view('clients.logHistoryCustomer', [
                'list' => $list,
                'list_2' => $list_2,
                'page_title' => 'Online Customer List',
                'start' => $start,
                'end'   => $end,
                'client' => $id
            ]);
        }

        if (checkAPI()) {
            $prevExpDate = Carbon::parse($prevExpDate)->format('Y-m-d 00:00:00');
            $currentDate = Carbon::parse($currentDate)->format('Y-m-d 23:59:59');
            $list = ApiBandwidthUsage::where('username', $id)
                ->whereBetween('session_start_time', [$prevExpDate, $currentDate])
                ->orderBy('id', 'desc')
                ->get();

            $data = [
                'list' => $list,
                'page_title' => 'Online Customer List',
                'start' => $start,
                'end'   => $end,
                'client' => $id
            ];

            return view('clients.apiBandwidthUsage.session', $data);
        }
    }

    public function logeSearchResult(Request $request)
    {
        // dd($request->all());
        if ($request->ajax()) {
            $from = Carbon::parse($request->from_date)->format('Y-m-d 00:00:00');
            $to = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');




            if (!checkAPI()) {

                $list[] = '';

                if ($request->from_date != null && $request->to_date != null) {
                    $list = DB::table('radacct')->select('*')
                        ->where('username', '=', $request->username)->whereBetween('acctstarttime', [$from, $to])
                        ->orderBy('acctstarttime', 'desc') ->get();
                }

                $list_2 = [];
                if(checkSettings('connect_second_data_base') == "enable"){

                    $list_2 = RadiusLog::where('username', $request->username)
                        ->whereBetween('session_start_time', [$from, $to])
                        ->orderBy('session_start_time', 'desc')
                        ->get();
                }

                return view('clients.logSearch', [
                    'list'       =>  $list,
                    'list_2'       =>  $list_2,
                ]);
            }

            if (checkAPI()) {
                $list = ApiBandwidthUsage::where('username', $request->username)
                    ->whereBetween('session_start_time', [$from, $to])
                    ->orderBy('id', 'desc')
                    ->get();

                $data = [
                    'list' => $list,
                    'page_title' => 'Online Customer List',
                    'start' => $from,
                    'end'   => $to,
                    'client' => $request->username
                ];

                return view('clients.apiBandwidthUsage.search', $data);
            }
        }
    }

    public function saveRadiusLogToClientTableCommand()
    {
        $all_clients = Client::get();

        $all_clients->chunk(10)->each(function ($clients) {
            StoreClientDownLoadUploadJob::dispatch($clients)->onQueue('user_log_queue');
        });
    }

    public function saveRadiusLogToClientTable($clients)
    {

        foreach ($clients as $client) {
            try{
                // Log::error("loop");
                $billing_cycle = $client->billing_cycle;
                $today_only_day = today()->day;
                if($today_only_day > $billing_cycle){
                    $get_date = Carbon::createFromDate(today()->year, today()->month, $billing_cycle);
                }else{
                    $get_date = Carbon::createFromDate(today()->year, today()->month, $billing_cycle)->subMonth();
                }

                $from_date = Carbon::parse($get_date)->format('Y-m-d 00:00:00');
                $to_date = Carbon::parse(today())->format('Y-m-d 23:59:59');

                $list = DB::table('radacct')
                ->selectRaw('SUM(acctinputoctets) as total_upload, SUM(acctoutputoctets) as total_download')
                ->where('username', $client->userid)
                ->whereBetween('acctstarttime', [$from_date, $to_date])
                ->first();

                if(checkSettings('connect_second_data_base') == "enable"){

                    $list2  = RadiusLog::selectRaw('SUM(uploaded) as total_upload, SUM(downloaded) as total_download')
                    ->where('username', $client->userid)
                    ->whereBetween('session_start_time', [$from_date, $to_date])
                    ->first();
                }

                $total_upload = $list->total_upload/8388608 +  $list2->total_upload/ 8;
                $total_download = $list->total_download/8388608 + $list2->total_download/8;
                Client::where('userid', $client->userid)->update(['up_bandwidth' => round($total_upload), 'down_bandwidth' => round($total_download)]);


            }catch(\Exception $e){
                Log::error($e->getMessage());
            }


        }
    }
}
