<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class RadiusTableController extends Controller
{
    public function checkInRedcheck()
    {
        if(auth()->user()->id == 1){
            return view('radiusTable.redcheck');
        }

    }

    public function searchInRedcheck(Request $request){

        $user = DB::table('radcheck')->where('username', $request->userid)->get();
        $reduser_group = DB::table('radusergroup')->where('username', $request->userid)->get();
        $data=[
            'users' => $user,
            'reduser_group' => $reduser_group,
        ];

        return view('radiusTable.resultredcheck',$data);

    }

    public function editRedcheck($id)
    {
        $user = DB::table('radcheck')->where('id', $id)->first();
        $data=[
            'user' => $user
        ];
        if(auth()->user()->id == 1){
            return view('radiusTable.editredcheck',$data);
        }
    }

    public function updateRedcheck(Request $request, $id){

        try{
            $user = DB::table('radcheck')->where('id', $id)->update([
                'username' => $request->user_name,
                'attribute' => $request->attribute,
                'op' => $request->op,
                'value' => $request->value,
            ]);
            // dd("comes");
            Toastr::success('User Updated Successfully In redcheck table', 'Success');
            return redirect()->back();

        }catch(\Exception $e){
            Toastr::error('Something went wrong', 'Error');
            dd($e);
            return redirect()->back();
        }

    }

    public function addredcheck(Request $request)
    {
        
            $client = Client::with('pops.nas','packages')->where('userid', $request->userid)->first();
            if($client){
                $expire_date = Carbon::parse($client->expire_date)->addDay($client->payment_dadeline)->format('Y-m-d 00:00:00');
                $today = Carbon::parse(today())->format('Y-m-d 00:00:00');
                if($client->clients_status == 'disable' || $client->clients_status == 'deactive'){

                    $user1 = DB::table('radcheck')->where('username', $client->userid)->where('attribute','Cleartext-Password')->first();
                    $user2 = DB::table('radcheck')->where('username', $client->userid)->where('attribute','NAS-IP-Address')->first();

                    if($user1 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'Cleartext-Password',
                            'op' => '!=',
                            'value' => $client->password
                        ]);
                    }else if($user1->op == ':='){
                        DB::table('radcheck')->where('username', $client->userid)->where('attribute','Cleartext-Password')->update([
                            'op' => '!=',
                        ]);
                    }

                    if($user2 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'NAS-IP-Address',
                            'op' => '!=',
                            'value' => $client->pops->nas->nasname
                        ]);
                    }else if($user2->op == ':='){
                        DB::table('radcheck')->where('username', $client->userid)->where('attribute','NAS-IP-Address')->update([
                            'op' => '!=',
                        ]);
                    }

                    $data=[
                        'message' => "User Not Found",
                    ];
                    return $data;
                }

                if( ($expire_date >= $today) || $client->pops->experity_check == "Yes"){

                    $user1 = DB::table('radcheck')->where('username', $request->userid)->where('attribute','Cleartext-Password')->first();
                    $user2 = DB::table('radcheck')->where('username', $request->userid)->where('attribute','NAS-IP-Address')->first();

                    $user_reduser_group = DB::table('radusergroup')->where('username', $request->userid)->first();

                    if($user1 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'Cleartext-Password',
                            'op' => ':=',
                            'value' => $client->password
                        ]);
                    }else if($user1->op == '!='){
                        DB::table('radcheck')->where('username', $request->userid)->where('attribute','Cleartext-Password')->update([
                            'op' => ':=',
                        ]);
                    }

                    if($user2 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'NAS-IP-Address',
                            'op' => ':=',
                            'value' => $client->pops->nas->nasname
                        ]);
                    }else if($user2->op == '!='){
                        DB::table('radcheck')->where('username', $request->userid)->where('attribute','NAS-IP-Address')->update([
                            'op' => ':=',
                        ]);
                    }

                    if($user_reduser_group == null){

                        DB::table('radusergroup')->insert([
                            'username' => $client->userid,
                            'groupname' => $client->packages->id,
                            'priority' => 1
                        ]);

                    }



                    $only_expire_date = Carbon::parse($client->expire_date)->format('Y-m-d 00:00:00');
                    if($client->pops->experity_check != "Yes" && $only_expire_date >= $today){
                        $client->clients_status = "active";
                        $client->save();
                    }

                    if($user1 != null && $user2 != null && $user_reduser_group != null){
                        $data=[
                            'message' => "User Already Exist In Redcheck and RedUserGroup Table",
                        ];

                        return $data;
                    }



                    $user = DB::table('radcheck')->where('username', $request->userid)->get();
                    $reduser_group = DB::table('radusergroup')->where('username', $request->userid)->get();

                    $data=[
                        'users' => $user,
                        'reduser_group' => $reduser_group,
                        'message' => "User Added Successfully In Redcheck Table",
                    ];

                    return view('radiusTable.resultredcheck',$data);
                }else{

                    $only_expire_date = Carbon::parse($client->expire_date)->format('Y-m-d 00:00:00');
                    if($client->pops->experity_check != "Yes" && $only_expire_date < $today ){
                        $client->clients_status = "expired";
                        $client->save();
                    }

                    $user1 = DB::table('radcheck')->where('username', $client->userid)->where('attribute','Cleartext-Password')->first();
                    $user2 = DB::table('radcheck')->where('username', $client->userid)->where('attribute','NAS-IP-Address')->first();

                    if($user1 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'Cleartext-Password',
                            'op' => '!=',
                            'value' => $client->password
                        ]);
                    }else if($user1->op == ':='){

                        DB::table('radcheck')->where('username', $client->userid)->where('attribute','Cleartext-Password')->update([
                            'op' => '!=',
                        ]);
                    }

                    if($user2 == null){

                        DB::table('radcheck')->insert([
                            'username' => $client->userid,
                            'attribute' => 'NAS-IP-Address',
                            'op' => '!=',
                            'value' => $client->pops->nas->nasname
                        ]);
                    }else if($user2->op == ':='){
                        DB::table('radcheck')->where('username', $client->userid)->where('attribute','NAS-IP-Address')->update([
                            'op' => '!=',
                        ]);
                    }


                    $user = DB::table('radcheck')->where('username', $request->userid)->get();
                    $reduser_group = DB::table('radusergroup')->where('username', $request->userid)->get();

                    $data=[
                        'users' => $user,
                        'reduser_group' => $reduser_group,
                        'message' => "User Added Successfully In Redcheck Table",
                    ];

                    return view('radiusTable.resultredcheck',$data);
                }

            }else{
                $data=[
                    'message' => "User Not Found",
                ];
                return $data;
            }


    }


    public function editRedUserGroup($id)
    {
        $user = DB::table('radusergroup')->where('id', $id)->first();
        $data=[
            'user' => $user
        ];
        if(auth()->user()->id == 1){
            return view('radiusTable.editRedUserGroup',$data);
        }
    }


    public function updateRedUserGroup(Request $request, $id){

        try{
            $user = DB::table('radusergroup')->where('id', $id)->update([
                'username' => $request->user_name,
                'groupname' => $request->groupname,
                'priority' => $request->priority,

            ]);

            Toastr::success('User Updated Successfully In radusergroup table', 'Success');
            return redirect()->back();

        }catch(\Exception $e){
            Toastr::error('Something went wrong', 'Error');
            dd($e);
            return redirect()->back();
        }

    }

    public function destroyReduserGroup($id)
    {
        $user = DB::table('radusergroup')->where('id', $id)->delete();
        Toastr::success('User Deleted Successfully In radusergroup table', 'Success');
        return redirect()->back();
    }

    public function destroyRedcheck($id)
    {
        $user = DB::table('radcheck')->where('id', $id)->delete();
        Toastr::success('User Deleted Successfully In radcheck table', 'Success');
        return redirect()->back();
    }
}
