<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Reseller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\ResellerRechargeReport;
use App\Models\User;

class ResellerRechargeReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:reseller-recharge-report',['only'=>['index']]);
    }

    public function index()
    {
        $start = Carbon::now()->today();

        // dd(ResellerRechargeReport::with('user')->get());
        $end = today();
        return view('resellerRecharge.index',[
            'page_title' => 'Manager Recharge',
            'start'      => $start,
            'end'        => $end,
            'reseller'   =>  Reseller::resellerList()->get(),
            'users'      =>  User::where('email', '!=', 'admin@billingfix.xyz')
                                ->where('email', '!=', 'rokibulhasan.356@gmail.com')
                                ->where('email', '!=', 'soiket@outlook.com')
                                ->where('email', '!=', 'support@yetfix.com')
                                ->get(),
        ]);
    }


    public function resellerRechargeSearch(Request $request)
    {
        if($request->ajax()){
            // dd($request->all());

            $from = $request->from_date == '' ? today() : Carbon::parse($request->from_date);
            $to   = $request->to_date == '' ? today() : Carbon::parse($request->to_date);

            $from = Carbon::parse($from)->format('Y-m-d 00:00:00');
            $to   = Carbon::parse($to)->format('Y-m-d 23:59:59');

            $resellerlist = Reseller::resellerList()->get();
            $reseller_ids = $resellerlist->pluck('id')->toArray();

            $user = $request->user == '' ? 'all' : $request->user;

            $list = ResellerRechargeReport::with('reseller','user','balance')
                                            ->whereBetween('created_at',[$from,$to]);

            // dd($list->get());
            if($request->reseller_id =='all' || $request->reseller_id == ''){

                $list->whereIn('reseller_id',$reseller_ids);


            }else{

                $list->where('reseller_id',$request->reseller_id);
            }
            if($user != 'all'){
                $list->where('user_id',$user);
            }


            return view('resellerRecharge.result',[
                'list'       =>  $list->get()
            ]);
        }
    }



}
