<?php

namespace App\Http\Controllers;

use App\Models\Reseller;
use App\Models\ResellerSmsGetway;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class ResellerSmsGetwayController extends Controller
{
    public function smsGateway($id){

        if (!auth()->user()->hasPermissionTo('reseller-sms-getway')) {
            return redirect()->back()->with('error_message', 'Permission Error!');
        }

        if(auth()->user()->hasRole('Reseller') || auth()->user()->hasRole('Reseller Admin')){
           $reseller = Reseller::list()->pluck('id')->toArray();
              if(in_array($id,$reseller)){
              }else{
                  return redirect()->route('resellers.index')->with('error_message', 'Permission Error!');
              }
        }

        $sms_getway = ResellerSmsGetway::where('reseller_id',$id)->first();
        if($sms_getway){

        }else{
            $sms_getway = new ResellerSmsGetway();

            $sms_array =  array(
                [
                    'sms_type' => 'other_reseller_customer_recharge',
                    'send_sms' => 'No',
                    'sms_body' => 'প্রিয় গ্রাহক ({c_name}), আপনার {month} মাস পর্যন্ত বিল সঠিক ভাবে সংগৃহিত হয়েছে। {reseller_name} এর সাথে থাকার জন্য ধন্যবাদ।  যেকোনো তথ্যের জন্য যোগাযোগ {reseller_mobile} এই নাম্বারে|',
                ],[
                    'sms_type' => 'other_reseller_customer_reminder',
                    'send_sms' => 'No',
                    'sms_body' => 'সম্মানিত গ্রাহক  আপনার {c_name}। ইন্টারনেট বিল পরিশোধের শেষ তারিখ {c_expire_date} দয়া করে আপনার বিলটি পরিশোধ করুন। ',
                    'days_before' => '2',
                ],[
                    'sms_type' => 'other_reseller_customer_expire',
                    'send_sms' => 'No',
                    'sms_body' => 'প্রিয় গ্রাহক {c_name} আপনার ইন্টারনেট বিল পরিশোধ করার সময়সীমা অতিক্রম করেছে। নিরবিচ্ছিন্ন সংযোগ পেতে বকেয়া টাকা পরিশোধ করুন।',
                ],[
                    'sms_type' => 'other_reseller_customer_create',
                    'send_sms' => 'No',
                    'sms_body' => '{reseller_name} এ আপনাকে স্বাগতম। আপনার User Id: {c_username} ও Password: {c_password} সংরক্ষন করে রাখোন।',
                ]
            );

            $sms_getway->reseller_id = $id;
            $sms_getway->sms_formate = json_encode($sms_array);
            $sms_getway->save();
            $sms_getway = ResellerSmsGetway::where('reseller_id',$id)->first();

        }

        $sms_data = collect(json_decode($sms_getway->sms_formate));


        $data = [
            'reseller_sms_getway' => $sms_getway,
            'reseller_id' => $id,
            'sms_data' => $sms_data,
        ];

        return view('reseller.resellerSmsGetway',$data);
    }


    public function resellerSmsGatewaySave(Request $request){

        $sms_getway = ResellerSmsGetway::where('reseller_id',$request->reseller_id)->first();
        $sms_array =  array(
            [
                'sms_type' => 'other_reseller_customer_recharge',
                'send_sms' => $request->other_reseller_customer_recharge_sms_setting,
                'sms_body' => $request->other_reseller_customer_recharge_sms_body,
            ],[
                'sms_type' => 'other_reseller_customer_reminder',
                'send_sms' => $request->other_reseller_customer_reminder_sms_setting,
                'sms_body' => $request->other_reseller_customer_reminder_sms_body,
                'days_before' => $request->other_reseller_customer_reminder_day,
            ],[
                'sms_type' => 'other_reseller_customer_expire',
                'send_sms' => $request->other_reseller_customer_expire_sms_setting,
                'sms_body' => $request->other_reseller_customer_expire_sms_body,
            ],[
                'sms_type' => 'other_reseller_customer_create',
                'send_sms' => $request->other_reseller_customer_create_sms_setting,
                'sms_body' => $request->other_reseller_customer_create_sms_body,
            ]
        );

        $sms_getway->reseller_id = $request->reseller_id;
        $sms_getway->sms_gateway = $request->gatway;
        $sms_getway->sms_formate = json_encode($sms_array);

        $sms_getway->save();

        Toastr::success('Reseller SMS Getway Update Successfully');
        return redirect()->back();

    }
}
