<?php

namespace App\Http\Controllers;

use App\Models\Nas;
use App\Models\Pop;
use App\Models\Client;
use App\Models\SessionTrack;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Brian2694\Toastr\Facades\Toastr;
use GrahamCampbell\ResultType\Success;

class SessionRefreshController extends Controller
{

    public function refreshSession($userid)
    {
        DB::table('radacct')
            ->whereNull('acctstoptime')
            ->where('username', $userid)
            ->delete();
        return redirect()->route('onlineCustomer')->with('success_message', 'Session Refreshed');
    }


    public function refresh_session($reseller = '')
    {
        SessionRefreshController::autoSessionDelete();
        return redirect()->route('dashboard')->with('success_message', 'Session Cleared');
    }

    public function autoSessionRefresh()
    {

        $online = DB::table('radacct')->whereNull('acctstoptime')->pluck('username')->toArray();



        $on = '';
        foreach ($online as $o) {
            $on .= "'" . $o . "',";
        }
        $online = rtrim($on, ',');


        $list = DB::select(DB::raw("select * from radpostauth where reply='Access-Reject' and id
                        IN (SELECT Max(id) FROM radpostauth where username in ($online) GROUP BY username)
                        "));




        foreach ($list as $l) {
        }



        $page_title = 'Rejected List';
        return view('dashboard.reject', [
            'page_title' => $page_title,
            'list'      => $list
        ]);
    }

    static function userDisconnectProcess($id)
    {
        $id = str_replace(' ', '_', $id);

        $userinfo = DB::table('radacct')->where('username', $id)->whereNull('acctstoptime')->first();





        if ($userinfo) {

            $nas = DB::table('nas')->where('nasname', $userinfo->nasipaddress)->first();

            if($nas){

                $result = exec('echo "User-Name=' . $userinfo->username . '" | radclient ' . $nas->nasname . ':3799 "disconnect" ' . $nas->secret);
            }else{
                $result = 'no nas found';
            }


        } else {

            $client = Client::with('pop', 'pop.nas')->where('userid', $id)->first();

            if ($client) {

                $result = exec('echo "User-Name=' . $client->userid . '" | radclient ' . $client->pop->nas->nasname . ':3799 "disconnect" ' .
                    $client->pop->nas->secret);
            } else {
                $result = 'no user';
            }
        }

        DB::table('radacct')->where('username', $id)->whereNull('acctstoptime')->update([
            'acctstoptime' => now()
        ]);

        echo $result;
    }



    static function online()
    {
        return DB::table('radacct')
            ->select('*')
            ->where('acctstoptime')
            ->pluck('username')
            ->toArray();
    }

    static function duplicateDisconnect()
    {

        $nulip = DB::table('radacct')
            ->select('username')
            ->whereNull('acctstoptime')
            ->where('framedipaddress', '0.0.0.0')
            ->pluck('username')
            ->toArray();



        $active = DB::table('radacct')
            ->select('username')
            ->whereNull('acctstoptime')
            ->groupBy('username')
            ->havingRaw('count(*) > 1')
            ->get();

        if (!empty($active)) {
            echo 'start duplicate disconnect';
            foreach ($active as $l) {
                SessionRefreshController::userDisconnectProcess($l->username);
            }
            echo '<br>';
            echo 'end';
        }






        if (!empty($nulip)) {
            DB::table('radacct')
                ->whereIn('username', $nulip)
                ->whereNull('acctstoptime')
                ->update([
                    'acctstoptime' => now()
                ]);

            echo 'start delete 0.0.0.0 ip disconnect';
            foreach ($nulip as $l) {
                SessionRefreshController::userDisconnectProcess($l);
            }
            echo '<br>';
            echo 'end';
        }
    }

    static function sessionRefreshIntervalNull()
    {

        // select acctstoptime, round(acctsessiontime/acctinterval) , acctinterval ,TIMESTAMPDIFF(MINUTE,acctstarttime,now())
        // from radacct where
        // acctstoptime is null and round(acctsessiontime/acctinterval) is null and acctinterval != 0 and TIMESTAMPDIFF(MINUTE,acctstarttime,now()) > 10

        // SELECT username,acctinterval,acctstarttime,acctupdatetime,TIMESTAMPDIFF(MINUTE, acctupdatetime, now() ) FROM `radacct` WHERE acctstoptime is null and TIMESTAMPDIFF(MINUTE, acctupdatetime, now() )>4





        // select * from radacct where acctupdatetime >= (NOW() - INTERVAL 5 MINUTE) and acctstoptime is not null and acctstoptime <= ( NOW() - INTERVAL 10 MINUTE)

        $list = DB::table('radacct')
            ->whereNull('acctstoptime')
            ->whereRaw('round(acctsessiontime/acctinterval) is null')
            ->whereRaw('TIMESTAMPDIFF(MINUTE,acctupdatetime,now()) > 5')
            // ->where(function ($query) {
            //     $query->whereRaw('TIMESTAMPDIFF(MINUTE, acctupdatetime, NOW()) < 5')
            //           ->orWhereRaw('TIMESTAMPDIFF(MINUTE, acctupdatetime, NOW()) > 15');
            // })
            ->whereRaw('acctstarttime < now() + INTERVAL 1 MINUTE')
            // ->selectRaw('username,acctstarttime,acctupdatetime,TIMESTAMPDIFF(MINUTE,acctstarttime,now()),round(acctsessiontime/acctinterval)')
            ->pluck('username')
            ->toArray();

        DB::table('radacct')
            ->whereIn('username', $list)
            ->whereNull('acctstoptime')
            ->update([
                'acctstoptime' => now()
            ]);


        foreach ($list as $l) {
            // SessionRefreshController::userDisconnectProcess($l);
        }

        DB::table('radacct')
            ->whereRaw('acctupdatetime >= (NOW() - INTERVAL 5 MINUTE) and acctstoptime is not null and acctstoptime <= ( NOW() - INTERVAL 10 MINUTE) AND acctstarttime < NOW() + INTERVAL 2 MINUTE')
            ->update([
                'acctstoptime' => null
            ]);
    }


    static function sessionRefreshIntervalDiff()
    {


        // select round(TIMESTAMPDIFF(MINUTE,acctstarttime,now())/(acctinterval/60)), round((acctsessiontime/acctinterval))+2 ,acctstoptime
        //from radacct where acctstoptime is null and round(TIMESTAMPDIFF(MINUTE,acctstarttime,now())/(acctinterval/60)) > round((acctsessiontime/acctinterval))+2

        //round(TIMESTAMPDIFF(MINUTE,acctstarttime,now())/(acctinterval/60))


        $list = DB::table('radacct')
            ->whereNull('acctstoptime')
            // ->whereRaw('round(TIMESTAMPDIFF(MINUTE,acctupdatetime,now())/(acctinterval/60)) > round((acctsessiontime/acctinterval))+2')
            ->whereRaw('round(TIMESTAMPDIFF(MINUTE,acctupdatetime,now())) > 5')
            // ->selectRaw('username,acctstarttime,acctupdatetime,TIMESTAMPDIFF(MINUTE,acctstarttime,now()),round(acctsessiontime/acctinterval)')
            ->pluck('username')
            ->toArray();

        DB::table('radacct')
            ->whereIn('username', $list)
            ->whereNull('acctstoptime')
            ->update([
                'acctstoptime' => now()
            ]);


        foreach ($list as $l) {
            //    SessionRefreshController::userDisconnectProcess($l);
        }
    }

    static function allUser()
    {
        $list = DB::table('clients')->pluck('userid')->all();

        foreach ($list as $l) {
            SessionRefreshController::userDisconnectProcess($l);
        }
    }

    static function deleteSessionIfStartTimeIsInFuture()
    {
        $list = DB::table('radacct')
            ->where('acctstarttime', '>', now())
            ->delete();
    }

    static function deleteOnlineCustomer(){

        DB::table('radacct')
            ->whereNull('acctstoptime')
            ->delete();
        Toastr::success('All online customer has been deleted', 'Success');
        return redirect()->back();
    }



    //SessionRefreshController::allUser();

    static function autoSessionDelete()
    {
        //  SessionRefreshController::duplicateDisconnect();

        SessionRefreshController::deleteSessionIfStartTimeIsInFuture();
        SessionRefreshController::sessionRefreshIntervalNull();
        SessionRefreshController::sessionRefreshIntervalDiff();




        SessionTrack::where('id', 1)->increment('count', 1);
    }

    public function singleIdDeleteFromRadacctTable(Request $request)
    {
        try{
            DB::table('radacct')
                ->where('username', $request->userid)
                ->whereNull('acctstoptime')
                ->delete();
            return ['status' => 'successfully deleted'];
        }catch(\Exception $e){
            return ['status' => 'can not delete'];
        }

    }
}
