<?php

namespace App\Http\Controllers;

use App\Classes\MikrotikService\Mikrotik;
use Carbon\Carbon;
use App\Models\Client;
use App\Models\Packages;
use App\Models\Token;
use App\Models\User_log;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Services\ClientServices;
use Exception;

class SupportHomeController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if ($request->user()->can('support_home_hide')) {
                abort(403);
            }
            return $next($request);
        })->only(['supportHome']);
    }

    public function supportHome(Request $request)
    {
        return view('support_home.create', [
            'page_title' => 'Customer Support Panel',


        ]);
    }
    public function getClientDetails(Request $request)
    {
        if ($request->ajax()) {

            if (!empty($request->type) && !empty($request->value)) {

                if ($request->type == 'id') {
                    $list = Client::list()->where($request->type, 'like', "%$request->value%")->get();
                } else {
                    $list = Client::list()->whereHas('clientsinfo', function ($q) use ($request) {
                        $q->where($request->type, 'like', "%$request->value%");
                    })->get();
                }

                if ($list->count() <= 0) {
                    return '<p class="text-center bg-gray-50 p-2">No User Found</p>';
                } else {
                    return view('support_home.result', [
                        'list'           =>  $list,
                    ]);
                }
            } else {
                return '<p class="text-center bg-gray-50 p-2">Please input user name or user id or contact number</p>';
            }
        }
    }
    public function getClientById(Request $request)
    {
        if ($request->ajax()) {

            if (!empty($request->id)) {

                $logForAPISecrets = "";
                $logType = '';

                $list = Client::with('clientsinfo', 'pop', 'packages', 'customerAccount', "pop.nas", 'customerToken')
                    ->with(['clientEditLog' => function ($q) {
                        $q->orderBy('id', 'desc')->limit(2);
                    }])
                    ->find($request->id);
                $list->created_by_name = user_name($list->created_by);

                $con_history = User_log::where('client_id', $list->id)
                    ->orderBy('id', 'DESC')
                    ->limit(10)
                    ->get();

                $last_online = null;
                if (checkAPI()) {
                    try {
                        $mkIp = $list->pop->nas->nasname;
                        $mkUser = $list->pop->nas->mikrotick_user;
                        $mkPass = $list->pop->nas->mikrotick_user_password;
                        $mkPort = $list->pop->nas->mikrotick_port;
                        $mk = new Mikrotik($mkIp, $mkUser, $mkPass, $mkPort ? (int)$mkPort : 8728);

                        $last_online = [];
                        try {
                            $userStatus = $mk->getActiveConnection($list->userid);
                            $last_online['framedipaddress'] = $userStatus["address"];
                        } catch (Exception $err) {
                            $last_online = null;
                        }
                        try {
                            if ($last_online) {
                                $clientInfo = $mk->getSecret($list->userid);
                                $last_online['acctstoptime'] = $clientInfo['last-logged-out'];
                            }
                        } catch (Exception $err) {
                            $last_online = null;
                        }

                        try {
                            $all_logs = array_reverse($mk->getSecretLogs());
                            foreach ($all_logs as $log) {
                                $time = $log["time"];
                                $message = str_replace(">", "", str_replace("<", "", $log["message"]));
                                if (str_contains($message,  $list->userid)) {
                                    $logForAPISecrets .= "<tr>
                                    <td> $time </td>
                                    <td>$message</td>
                                    </tr>";
                                }
                            }
                        } catch (Exception $err) {
                        }
                    } catch (Exception $err) {
                    }
                } else {
                    $last_online = DB::table('radacct')->where('username', $list->userid)->whereNull('acctstoptime')->first();
                }

                $login_attempts = DB::table('radpostauth')->where('username', $list->userid)->orderBy('id', 'DESC')->limit(10)->get();
                if (auth()->user()->hasRole(['Sub Reseller'])) {
                    $log_activities = DB::table('sub_reseller_balance_log_report')->where('client_id', $list->id)->orderBy('id', 'DESC')->limit(10)->get();

                }else{
                    $log_activities = DB::table('reselle_balance_log_reports')->where('client_id', $list->id)->orderBy('id', 'DESC')->limit(10)->get();

                }
                $pending_token = Token::with('category', 'Code')->where('clientId', $list->id)->where('status', 'Active')->orderBy('id', 'DESC')->limit(10)->get();

                $html = '';
                foreach ($login_attempts as $row) {
                    $html .= '<tr><td>' . Carbon::parse($row->authdate)->isoFormat('LLLL') . '</td>' .
                        '<td>' . $row->username . '</td>' .
                        '<td>' . $row->pass . '</td>' .
                        '<td>' . $row->mac . '</td>' .
                        '<td>' . $row->reply . '</td>' .
                        '<td>' . $row->mikrotik . '</td>' .
                        '</tr>';
                }
                $output = '';
                foreach ($log_activities as $row) {
                    $output .= '<tr><td>' . Carbon::parse($row->created_at)->isoFormat('LLLL') . '</td>' .
                        '<td>' . $row->action . '</td>' .
                        '<td>' . $row->remarks . '</td>' .
                        '</tr>';
                }

                $token_output = '';
                foreach ($pending_token as $row) {
                    $token_output .= '<tr><td>' . Carbon::parse($row->created_at)->isoFormat('LLLL') . '</td>' .
                        '<td>' . $row->token . '</td>' .
                        '<td>' . $row->category->tokenCategory . '</td>' .
                        '<td>' . $row->Code->tokenCode . '</td>' .
                        '<td>' . $row->reportedBy . '</td>' .
                        '<td>' . $row->reporterContact . '</td>' .
                        '<td>' . $row->description . '</td>' .
                        '<td>' . $row->status . '</td>' .
                        '</tr>';
                }

                $con_output = '';
                foreach ($con_history as $row) {
                    if ($row->log_type == 'id_enable') {
                        $logType = '<span class="bg bg-green btn-block text-center">Enable</span>';
                    } elseif ($row->log_type == 'id_disable') {
                        $logType = '<span class="bg bg-warning btn-block text-center">Disable</span>';
                    } elseif ($row->log_type == 'id_deactive') {
                        $logType = '<span class="bg bg-danger btn-block text-center">Deactive</span>';
                    } elseif ($row->log_type == 'id_approved') {
                        $logType = '<span class="bg bg-success btn-block text-center">Approved</span>';
                    }  elseif ($row->log_type == 'id_close') {
                        $logType = '<span class="bg bg-danger btn-block text-center">Close</span>';
                    } elseif ($row->log_type == 'id_restore') {
                        $logType = '<span class="bg bg-danger btn-block text-center">Restore</span>';
                    }

                    $con_output .= '<tr><td>' . Carbon::parse($row->created_at)->isoFormat('LLLL') . '</td>' .
                        '<td>' . $logType . '</td>' .
                        '<td>' . $row->details . '</td>' .
                        '<td>' . user_name($row->user_id) . "<br>" . user_email($row->user_id)  . '</td>' .
                        '</tr>';
                }

                if ($list == null) {
                    return '<p class="text-center bg-gray-50 p-2">No User Found</p>';
                }

                $edit_log = '';
                if ($list->clientEditLog) {
                    $edit_log_data = $list->clientEditLog;
                    foreach ($edit_log_data as $row) {

                        $old = json_decode($row->old_data);
                        $new = json_decode($row->new_data);

                        $old_client_info = $old->clientsinfo;
                        $new_client_info = $new->clientsinfo;

                        $change_old = '';
                        $change_new = '';
                        foreach ($old as $key => $value) {
                            if ($old->$key != $new->$key && $key != "clientsinfo" && $key != "updated_at") {
                                $change_old .= '<span class="badge badge-primary">' . $key . '</span><span> : ' . $old->$key . '</span><br>';
                                $change_new .= '<span class="badge badge-warning">' . $key . '</span><span> : ' . $new->$key . '</span><br>';
                            }
                        }

                        $change_old_clientinfo = '';
                        $change_new_clientinfo = '';
                        foreach ($old_client_info as $key => $value) {
                            if ($old_client_info->$key != $new_client_info->$key && $key != "updated_at") {
                                $change_old_clientinfo .= '<span class="badge badge-primary">' . $key . '</span><span> : ' . $old_client_info->$key . '</span><br>';
                                $change_new_clientinfo .= '<span class="badge badge-warning">' . $key . '</span><span> : ' . $new_client_info->$key . '</span><br>';
                            }
                        }
                        $edit_log .= '<tr><td>' . user_name($row->user_id) .  '</td>' .
                            '<td>' . $change_old . $change_old_clientinfo . '</td>' .
                            '<td>' . $change_new . $change_new_clientinfo . '</td>' .
                            '</tr>';
                    }

                    $edit_log .= "<tr><td colspan=3><a class='btn btn-secondary btn-block' href='get-all-edit-log-history/" . $request->id . "'>view All Edit History</a></td></tr>";
                }
            }

            return $data = [
                'r'                        =>  $list,
                'login_attempts'           =>  checkAPI() ? $logForAPISecrets : $html,
                'log_activities'           =>  $output,
                'connection_history'       =>  $con_output,
                'last_online'              =>  $last_online,
                'edit_log'                 =>  $edit_log,
                'token_output'             =>  $token_output,
            ];
        }
    }


    public function getAllEditLogHistory($id)
    {
        $client = Client::with('clientsinfo', 'pop', 'packages', 'user', 'customerAccount', "pop.nas", 'clientEditLog.user')->find($id);

        $data = [
            'client' => $client,
        ];
        return view('support_home.clienEditLog', $data);
    }
}
