<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\Packages;
use App\Models\Pop;
use App\Models\SubPackage;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\Validator;

class ClientsImportToCustomer implements ToCollection
{
    use Importable;

    /**
    * @param Collection $collection
    */
    public function collection(Collection $rows)
    {
        $rowNumber = 1;
        for($i = 1; $i < count($rows); $i++){
            $row = $rows[$i];

            $rowNumber++;
            // dd($row);
            $customRules = [
                '0' => 'required',
                '1' => 'required',
                '2' => 'required',
                '3' => 'nullable',
                '4' => 'required',
                '5' => 'nullable',
                '6' => 'required',
                '7' => 'required',
                // Add more rules as needed
            ];

            $customAttributes = [
                '0' => 'pppoe name',
                '1' => 'pppoe password',
                '2' => 'user name',
                '3' => 'contact no',
                '4' => 'package name',
                '5' => 'reseller name',
                '6' => 'pop name',
                '7' => 'billing cycle',
                // Define custom attribute names for other fields as needed
            ];
            // dd($row->toArray());

            // Validate the rules against each row
            $validator = Validator::make($row->toArray(), $customRules);

            // dd($validator->errors());

            // Check for validation errors
            if ($validator->fails()) {
                // Handle validation errors, e.g., log errors or return a response
                // You can access the errors using $validator->errors()

                $errors = $validator->errors();
                $customErrors = [];
                foreach ($errors->keys() as $field) {
                    $customErrors[] = "Row $rowNumber: " . $customAttributes[$field] . ' is required <br>' ;
                }

                throw new \Exception(implode('', $customErrors));
            }

            $list_billing_cycle = preg_replace("/[^0-9]/", "", $row[7]);
            $int_billing_cycle = $list_billing_cycle;
            $currentMonth = Carbon::now()->month;

            if ($row[15] != null){
                if (is_numeric($row[15])) {
                    // Convert the numeric value to a date using Carbon
                    $expire = Carbon::parse(($row[15] - 25569) * 86400)->format('Y-m-d 00:00:00');
                } else {
                    // If $row[15] is not numeric, use its original value
                    $expire = Carbon::parse($row[15])->format('Y-m-d 00:00:00');
                }
            } else {
                $expire = date('2024-'.$currentMonth.'-' . $int_billing_cycle . ' 00:00:00');
                $today = Carbon::parse(today())->format('Y-m-d 00:00:00');
                if(strtotime($expire) < strtotime($today) ){
                    $expire = Carbon::parse($expire)->addMonth();
                }
            }


            $expire = date('2024-'.$currentMonth.'-' . $int_billing_cycle . ' 00:00:00');
            $today = Carbon::parse(today())->format('Y-m-d 00:00:00');
            if(strtotime($expire) < strtotime($today) ){
                $expire = Carbon::parse($expire)->addMonth();
            }

            $pop = Pop::where('popname', $row[6])->first();
            if ($pop == null) {
                throw new \Exception($row[6] . " Pop not found". " at row " . $rowNumber);
            }

            if($pop->subreseller == 'yes'){
                $subPackage = SubPackage::where('name', $row[4])->first();
                if ($subPackage == null) {
                    throw new \Exception("Sub Package not found");
                }
                $package = Packages::where('id', $subPackage->package_id)->first();

            }else{
                $package = Packages::where('package_name', $row[4])->first();
                if ($package == null) {
                    throw new \Exception("Package not found");
                }

            }



            if ($row[13] != null) {
                if (is_numeric($row[13])) {
                    // Convert the numeric value to a date using Carbon
                    $joiningDate = Carbon::parse(($row[13] - 25569) * 86400)->format('Y-m-d 00:00:00');
                } else {
                    // If $row[13] is not numeric, use its original value
                    $joiningDate = Carbon::parse($row[13])->format('Y-m-d 00:00:00');
                }
            }else{
                $joiningDate = '';
            }

            $check_client = Client::where('userid', trim($row[0]))->first();

            if($check_client == null)
            {
                $client = new Client();
                $client->userid = trim($row[0]);
                $client->password = trim($row[1]);
                $client->package_id = $package->id;
                if (isset($subPackage)){
                    $client->sub_package_id = $subPackage->id;
                }
                $client->pop_id = $pop->id;
                $client->billing_cycle = $int_billing_cycle;
                $client->expire_date = Carbon::parse($expire)->format('Y-m-d 00:00:00');
                $client->required_cable = 0;
                $client->created_by = auth()->user()->id;
                $client->client_approval = "pending";
                $client->clients_status = "deactive";

                $client->save();
                $client->customer_id = $client->id;
                $client->save();

                $clientInfo = new Clientsinfo();
                $clientInfo->client_id = $client->id;
                $clientInfo->clients_name = $row[2];
                if (strlen($row[3]) < 11) {
                    $clientInfo->contact_no = '0' . $row[3];
                }
                if (strlen($row[3]) == 11) {
                    $clientInfo->contact_no = $row[3];
                }
                $clientInfo->email = $row[8] ?? "";
                $clientInfo->father_name = $row[9] ?? "";
                $clientInfo->mother_name = $row[10] ?? "";
                $clientInfo->area = $row[11] ?? "";
                $clientInfo->remarks = $row[12] ?? "";
                $clientInfo->joinDate = $joiningDate;
                $clientInfo->cable_type = $row[14] ?? "";

                $clientInfo->save();
            }
        }
    }
}
