<?php

namespace App\Jobs;

use App\Http\Controllers\ClientController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BandwidthStoreJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $clients;

    public function __construct($clients)
    {
        $this->clients = $clients;
    }

    public function handle()
    {
        foreach ($this->clients as $user) {
            echo $user->id . '<br>';
            (new ClientController)->storeCustomerBandwidth($user);
        }
    }
}
