<?php

namespace App\Jobs;

use App\Models\SmsLog;
use App\Services\Sms;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class ExpireCustomerNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        if(isset($this->data['contact_no'])){
            $contact = $this->data['contact_no'];
        }else{
            $contact = $this->data['contact'] ?? "";
        }

        $message = (new Sms)->send_sms($contact, $this->data['message']);

        SmsLog::create([
            'contact' => $contact,
            'message' => $this->data['message'],
            'type' => $this->data['type'] ?? 'other',
            'delivery_message' => $message,
            'status' => 'processing'
        ]);
    }
}
