<?php

namespace App\Jobs;

use App\Http\Controllers\RadiusLogController;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class MigrateRadiusLog implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $logs;
    public function __construct($logs)
    {
        $this->logs = $logs;
    }


    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        (new RadiusLogController)->migrateRadiusLog($this->logs);

    }
}
