<?php

namespace App\Jobs;

use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Models\Client;
use App\Models\Pop;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class PopDeactiveJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $pop_id;
    public function __construct($pop_id)
    {
        $this->pop_id = $pop_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $client = Client::where('pop_id', $this->pop_id)->get();
        foreach ($client as $value) {
            try{
                (new IdEnableDisableController)->idDeactive($value->id, "deactive all customer from pop");
            }catch(\Exception $e){

            }
        }

    }
}
