<?php

namespace App\Jobs;

use App\Models\ResellerSmsLog;
use App\Services\ResellerSms;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ResellerSendSms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $contact = $this->data['contact'];
        $message = $this->data['message'];
        $type = $this->data['type'] ?? 'other';
        $reseller_id = $this->data['reseller_id'];
        $api_url = $this->data['api'];

        if($api_url){

            $response = (new ResellerSms)->send_sms($contact, $message, $api_url);
            ResellerSmsLog::create([
                'reseller_id' => $reseller_id,
                'contact' => $contact,
                'message' => $message,
                'type' => $type,
                'delivery_message' => $response,
                'status' => 'processing'
            ]);
        }
    }
}
