<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\Packages;
use App\Models\BillGenerate;
use App\Models\CustomerAccount;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Serializable;

class Client extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = ['id'];

    protected $attributes = [
        'client_approval' => 'pending',
    ];





    public function reseller()
    {
        return $this->belongsTo(Reseller::class, 'reseller_id');
    }

    public function resellerList()
    {
        return $this->hasMany(Pop::class, 'pop_id');
    }

    public function customerAccount()
    {
        return $this->hasOne(CustomerAccount::class, 'client_id', 'id');
    }
    public function pops()
    {
        return $this->belongsTo(Pop::class, 'pop_id', 'id');
    }

    public function nas()
    {
        return $this->belongsTo(Nas::class, 'nas_id');
    }

    public function pop()
    {
        return $this->belongsTo(Pop::class, 'pop_id');
    }

    public function popbillable()
    {
        return $this->belongsTo(Pop::class, 'pop_id')->where('bill_generate', 'yes');
    }


    public function packages()
    {
        return $this->hasOne(Packages::class, 'id', 'package_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function clientsinfo()
    {
        return $this->hasOne(Clientsinfo::class, 'client_id', 'id');
    }

    public function subpack()
    {
        return $this->hasOne(SubPackage::class, 'id', 'sub_package_id');
    }

    public function paymentBill()
    {
        return $this->hasMany(Billpayment::class, 'client_id', 'id');
    }


    public function generatedBill()
    {
        return $this->hasMany(BillGenerate::class, 'client_id', 'id');
    }

    public function balanceAdjustment()
    {
        return $this->hasMany(BalanceAdjustment::class, 'client_id', 'id');
    }
    public function customerToken()
    {
        return $this->hasOne(Token::class, 'clientId', 'id');
    }

    public function totalGeneratedBill()
    {
        return $this->generatedBill()->sum('bill_amount');
    }
    public function generatedBillNow()
    {
        return $this->hasMany(BillGenerate::class, 'client_id', 'id')
            ->whereBetween('created_at', [now()->firstOfMonth(), now()->lastOfMonth()->addDay()])
            ->where(function ($q) {
                $q->where('billing_type', 'monthly')
                    ->oRwhere('billing_type', 'reactive');
            });
    }



    public function generatedBillOther()
    {
        return $this->hasMany(BillGenerate::class, 'client_id', 'id')
            ->whereBetween('created_at', [now()->firstOfMonth(), now()->lastOfMonth()->addDay()])
            ->where(function ($q) {
                $q->where('billing_type', '!=', 'monthly')
                    ->where('billing_type', '!=', 'reactive');
            });
    }

    static function online($lists)
    {
        return DB::table('radacct')
            ->whereNull('acctstoptime')
            ->whereIn('username', $lists)
            ->selectRaw('username')
            ->pluck('username')
            ->toArray();
    }

    static function list($type = 'approved', $popType = null)
    {
        $list = Client::with('clientsinfo', 'packages:id,package_name,package_rate', 'subpack:id,name,rate', 'pop:id,popname,nas_id,bill_generate,subreseller', 'customerAccount', 'pop.reseller', "pop.nas")
            ->selectRaw('crm_status,id,pop_id,billing_cycle,package_id,userid,password,ip_address,expire_date,payment_dadeline,created_by,client_approval,created_at,clients_status,sub_package_id,customer_id,marketed_by,deleted_at,parmanent_discount,required_cable,ignoreMKCheck,closed_at,bandwidth_limit,up_bandwidth,down_bandwidth,isStatic,auto_deactive,customer_code')
            ->where('client_approval', $type)
            ->whereIn('pop_id', userPops()->pluck('id'));

        return $list;
    }

    static function withTrashedList($type = 'approved', $popType = null)
    {
        $list = Client::withTrashed()->with('clientsinfo', 'packages:id,package_name,package_rate', 'subpack:id,name,rate', 'pop:id,popname,nas_id,bill_generate,subreseller', 'customerAccount', 'pop.reseller', "pop.nas")
            ->selectRaw('id,pop_id,billing_cycle,package_id,userid,password,ip_address,expire_date,payment_dadeline,created_by,client_approval,created_at,clients_status,sub_package_id,customer_id,marketed_by,deleted_at,parmanent_discount,required_cable,ignoreMKCheck,closed_at,bandwidth_limit,up_bandwidth,down_bandwidth,isStatic,auto_deactive,customer_code')
            ->where('client_approval', $type)
            ->whereIn('pop_id', userPops()->pluck('id'));

        return $list;
    }

    static function clist($type = 'approved', $popType = null)
    {
        $list = Client::with('clientsinfo', 'packages:id,package_name,package_rate', 'subpack:id,name,rate', 'pop:id,popname,bill_generate,subreseller', 'pop.reseller')
            ->selectRaw('id,pop_id,billing_cycle,package_id,userid,password,ip_address,expire_date,payment_dadeline,created_by,client_approval,created_at,clients_status,sub_package_id,customer_id,marketed_by')
            ->where('client_approval', $type)
            ->whereIn('pop_id', userPops()->pluck('id'));
        return $list;
    }


    static function pop_ids()
    {
        $uid = auth()->user()->id;
        $pop_ids = null;

        if (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

            $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();
        } elseif (auth()->user()->hasRole('Sub Reseller')) {

            $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
        }

        return $pop_ids;
    }

    static function conditionlist()
    {

        $uid = auth()->id();



        if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'PendingCustomerChecker'])) {

            $list = Client::where('client_approval', 'pending');
        } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

            $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

            $list = Client::whereIn('pop_id', $pop_ids)->where('client_approval', 'pending');;
        } elseif (auth()->user()->hasRole('Sub Reseller')) {

            $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
            $list = Client::whereIn('pop_id', $pop_ids)
                ->where('client_approval', 'pending');
        } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

            $list = Client::whereIn('pop_id', []);
        }

        return $list ?? '';
    }

    // all customer
    static function allCustomerlist()
    {

        $uid = auth()->id();



        if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'PendingCustomerChecker', 'Billing Man'])) {

            $list = array();
            $clientsaccount = DB::table('clients')
                ->get();
            $list['allCustomer']  =  $clientsaccount->count();
        } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $list = array();

            $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

            $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

            $data = Client::whereIn('pop_id', $pop_ids);

            $list['totalResellerUser'] = $data->count();
        } elseif (auth()->user()->hasRole('Sub Reseller')) {

            $list = array();
            $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
            $data = Client::whereIn('pop_id', $pop_ids);
            $list['allSubresellerUser'] = $data->count();
        } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

            $list = Client::whereIn('pop_id', []);
        }

        return $list;
    }

    //active Customer
    // static function activeCustomerlist()
    // {

    //     $uid = auth()->id();



    //     if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'Billing Man'])) {

    //         $list = array();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->get();
    //         $list['totalActiveCustomer'] = $clientsaccount->where('clients_status', 'active')->count();
    //     } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

    //         $list = array();

    //         $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

    //         $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         // $data = Client::whereIn('pop_id',$pop_ids);

    //         $list['totalActiveResellerCustomer'] = $clientsaccount->where('clients_status', 'active')->count();
    //     } elseif (auth()->user()->hasRole('Sub Reseller')) {
    //         $list = array();
    //         $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();
    //         $list['allSubresellerActiveUser'] = $clientsaccount->where('clients_status', 'active')->count();
    //     } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

    //         $list = Client::whereIn('pop_id', []);
    //     }

    //     return $list;
    // }


    //deactive Customer
    // static function deactiveCustomerlist()
    // {

    //     $uid = auth()->id();



    //     if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'Billing Man'])) {

    //         $list = array();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->get();
    //         $list['totalDeactiveCustomer'] = $clientsaccount->where('clients_status', 'deactive')->count();
    //     } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

    //         $list = array();

    //         $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

    //         $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         // $data = Client::whereIn('pop_id',$pop_ids);

    //         $list['totaldectiveResellerCustomer'] = $clientsaccount->where('clients_status', 'deactive')->count();
    //     } elseif (auth()->user()->hasRole('Sub Reseller')) {
    //         $list = array();
    //         $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();
    //         $list['allSubresellerdectiveUser'] = $clientsaccount->where('clients_status', 'deactive')->count();
    //     } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

    //         $list = Client::whereIn('pop_id', []);
    //     }
    //     return $list;
    // }


    // static function expireClientList()
    // {

    //     $uid = auth()->id();



    //     if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'Billing Man'])) {

    //         $list = array();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->where('deleted_at', '=', null)
    //             ->get();
    //         $list['totalExpireCustomer'] = $clientsaccount->where('clients_status', 'expired')->count();
    //     } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

    //         $list = array();

    //         $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

    //         $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         // $data = Client::whereIn('pop_id',$pop_ids);

    //         $list['totalExpireResellerCustomer'] = $clientsaccount->where('clients_status', 'expired')->count();
    //     } elseif (auth()->user()->hasRole('Sub Reseller')) {
    //         $list = array();
    //         $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();
    //         $list['allSubresellerExpireUser'] = $clientsaccount->where('clients_status', 'expired')->count();
    //     } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

    //         $list = Client::whereIn('pop_id', []);
    //     }

    //     return $list;
    // }


    // static function monthlyClientList()
    // {

    //     $uid = auth()->id();



    //     if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'Billing Man'])) {

    //         $list = array();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->get();
    //         $thisMonth = Carbon::now()->firstOfMonth();
    //         $list['totalMonthlyCustomer'] = $clientsaccount->where('cdate', '>=', $thisMonth)->count();
    //     } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

    //         $list = array();

    //         $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

    //         $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         // $data = Client::whereIn('pop_id',$pop_ids);
    //         $thisMonth = Carbon::now()->firstOfMonth();
    //         $list['totalResellerMonthlyCustomer'] = $clientsaccount->where('cdate', '>=', $thisMonth)->count();
    //         //dd($list);


    //     } elseif (auth()->user()->hasRole('Sub Reseller')) {
    //         $list = array();
    //         $pop_ids = DB::table('pop_user')->where('user_id', $uid)->pluck('pop_id')->toArray();
    //         $clientsaccount = DB::table('clients')
    //             ->leftJoin('customer_accounts', 'clients.id', '=', 'customer_accounts.client_id')
    //             // ->leftJoin('clientsinfo','clients.id','=','clientsinfo.client_id')
    //             ->select(
    //                 'clients.id as id',
    //                 'pop_id',
    //                 'package_id',
    //                 'userid',
    //                 'expire_date',
    //                 'created_by',
    //                 'client_approval',
    //                 'clients.created_at as cdate',
    //                 'clients.updated_at as udate',
    //                 'clients_status',
    //                 'totalPaid',
    //                 'dueAmount',
    //                 'totalDiscount',
    //                 'totalBillAmount'
    //             )
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         $thisMonth = Carbon::now()->firstOfMonth();
    //         $list['allSubresellerNewUser'] = $clientsaccount->where('cdate', '>=', $thisMonth)->count();
    //     } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

    //         $list = Client::whereIn('pop_id', []);
    //     }

    //     return $list;
    // }

    // static function closedClientList()
    // {

    //     $uid = auth()->id();



    //     if (auth()->user()->hasRole(['Admin', 'Accounts Manager', 'Support Manager', 'Accounts Executive', 'Billing Man'])) {

    //         $list = array();
    //         $closedClients = DB::table('clients')
    //             ->where('deleted_at', '!=', NULL)->get();
    //         $list['totalClosedCustomer'] = $closedClients->count();
    //     } elseif (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

    //         $list = array();

    //         $reseller_ids = DB::table('reseller_user')->where('user_id', $uid)->pluck('reseller_id')->toArray();

    //         $pop_ids = Pop::with('reseller', 'nas')->whereIn('reseller_id', $reseller_ids)->pluck('id')->toArray();

    //         $closedClients = DB::table('clients')
    //             ->where('deleted_at', '!=', NULL)
    //             ->whereIn('pop_id', $pop_ids)
    //             ->get();

    //         // $data = Client::whereIn('pop_id',$pop_ids);
    //         // $thisMonth = Carbon::now()->firstOfMonth();
    //         $list['totalClosedResellerCustomer'] = $closedClients->count();
    //         //dd($list);


    //     } elseif (auth()->user()->hasRole('Sub Reseller')) {
    //         $list = array();
    //         // $pop_ids = DB::table('pop_user')->where('user_id',$uid)->pluck('pop_id')->toArray();
    //         // $data = Client::whereIn('pop_id',$pop_ids);
    //         // $list['allSubesellerUser'] = $data->count();


    //     } elseif (!auth()->user()->hasRole(['Admin', 'Support Manager', 'Accounts Manager', 'Accounts Executive'])) {

    //         $list = Client::whereIn('pop_id', []);
    //     }

    //     return $list;
    // }

    public function clientEditLog()
    {
        return $this->hasMany(ClientEditLog::class, 'client_id', 'id')->orderBy('id', 'desc');
    }

    public function resellerBlanceLogCurrentMonth()
    {
        return $this->hasMany(ReselleBalanceLogReport::class, 'client_id', 'id')->whereBetween('created_at', [Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()]);
    }

    public function resellerBlanceLogPreviousMonth()
    {
        return $this->hasMany(ReselleBalanceLogReport::class, 'client_id', 'id')->whereBetween('created_at', [Carbon::now()->startOfMonth()->subMonth(), Carbon::now()->endOfMonth()->subMonth()]);
    }

    public function customerAccountAdjustment()
    {
        return $this->hasMany(CustomerBalanceAdjustment::class, 'client_id', 'id');
    }

    public function adminUser()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
