<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Packages extends Model
{
use HasFactory;

    protected $fillable = [
        'package_name',
        'package_rate',
        'pool_name',
        'commission',
        'profile_name',
        'speed_up',
        'speed_down',
        'limite_quantity',
        'package_bandwidth',
        'btrc_package_price'
    ];

    protected $table = 'packages';

    public function resellers()
    {
        return $this->belongsTo(Resellers::class,'reseller_id');
    }

    static function packageList($con=''){
        if(empty($con)){

        }else{

        }
    }

    static function list(){



        $list = DB::table('packages')->whereIn('id',$ids)->get();
    }




    static function conditionalList()
    {
        $id=auth()->id();


        if(auth()->user()->hasRole('Sub Reseller')){
            $plist = [] ;
            $list = Packages::whereIn('id',$plist)->paginate();



        }elseif(auth()->user()->hasRole(['Reseller Admin','Reseller'])){

            $reseller_ids = DB::table('reseller_user')->where('user_id',$id)->pluck('reseller_id')->toArray();
            $resellers = Reseller::whereIn('id',$reseller_ids)->pluck('package_list')->toArray();
            // dd($resellers);

            $plist =  array_unique(explode(',',implode(',',$resellers)));
            $list = Packages::whereIn('id',$plist)->paginate();
            // dd($plist);

        }else{
            $list = Packages::paginate(500);

        }

        return $list;
    }


}
