<?php

namespace App\Models;

use App\Models\Balance;
use App\Models\Reseller;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReselleBalanceLogReport extends Model
{
    use HasFactory;

    protected $table = 'reselle_balance_log_reports';

    protected $guarded  = ['id'];

    public function reseller()
    {
        return $this->hasOne(Reseller::class,'id','reseller_id');
    }

    public function client(){
        return $this->hasOne(Client::class,'id','client_id');
    }

    public function resellerBalanceAdjust($client,$amount,$message)
    {
        ReselleBalanceLogReport::create(
            [
                'reseller_id' => $client->pops->reseller_id,
                'client_id'   => $client->id,
                'action'      => $message,
                'amount'      => -$amount,
                'remarks'     => 'Created BY ' . auth()->user()->email,
            ]
        );
        Balance::balanceDeductForUserRecharge('reseller', $client->pops->reseller_id, -$amount);        
    }

  


}


