<?php

namespace App\Models;

use App\Models\Balance;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SubResellerBalanceLogReport extends Model
{
    use HasFactory;
    protected $table = 'sub_reseller_balance_log_report';
    protected $guarded = [];

    public function user(){
        return $this->hasOne(User::class,'id','user_id');
    }
    public function client(){
        return $this->hasOne(Client::class,'id','client_id')->withTrashed();
    }

    public function pop()
    {
        return $this->hasOne(Pop::class,'id','sub_reseller_id',);
    }

    public function subResellerBalanceAdjust($client,$amount,$message)
    {
        SubResellerBalanceLogReport::create(
            [
                'reseller_id'       => $client->pops->reseller_id,
                'client_id'         => $client->id,
                'action'            => $message,
                'amount'            => -$amount,
                'sub_reseller_id'   => $client->pops->id,
                'remarks'           => 'Created BY ' . auth()->user()->email
            ]
        );

        Balance::balanceDeductForUserRecharge('pop', $client->pops->id, -$amount);
    }





}
