<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAccounting extends Model
{
    use HasFactory;
    protected $guarded = ['id'];


    static function userAcStore($amount,$actions,$client_id=null,$accounting_type='',$transaction_type='',$user_id = null)
    {
 
        if ($user_id == null) {
            $user_id = auth()->user()->id;
        }
        
        $id = UserAccounting::create([
            'received_amount'   => $amount,
            'paid_amount'       => 0,
            'actions'           => $actions,
            'commetns'          => '',
            'user_id'           => $user_id,
            'client_id'         => $client_id,
            'accounting_type'   => $accounting_type,
            'transaction_type'   => $transaction_type,
        ]);
        return $id;
    }

    static function userAcPaid($amount,$actions,$user_id,$accounting_type='',$transaction_type='')
    {               
        
        $id = UserAccounting::create([
            'received_amount'   => $amount,
            'paid_amount'       => 0,
            'actions'           => $actions,
            'commetns'          => '',
            'user_id'           => $user_id,
            'client_id'         => '',
            'accounting_type'   => $accounting_type,
            'transaction_type'   => $transaction_type,
        ]);
        return $id;
    }

    static function userAcDeduct($amount,$actions,$user_id)
    {          
        
        $id = UserAccounting::create([
            'received_amount'   => 0,
            'paid_amount'       => $amount,
            'actions'           => '',
            'comments'          => $actions,
            'user_id'           => $user_id
        ]);

        return $id;
    }


}
