<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Balance;
use App\Models\Packages;
use App\Models\Reseller;
use App\Models\SubPackage;
use App\Services\PriceCalculate;

class ExpireCheck
{


  static function getResellerBalance($type, $id)
  {
    $balance = Balance::whereType($type)
                      ->whereType_id($id)
                      ->first();

        if ($balance !== null) {
          return $balance->amount;
        } else {
          return 0;
        }
  }

  static function expireForPackage($pop, $package, $billing_cycle, $expire_date)
  {

    dd($expire_date);

    if ($pop != '' && $package != '' && $billing_cycle != '') {

      // dd($package);
      $info['subReseller'] = 'no';


      $curBalance =  ExpireCheck::getResellerBalance('reseller', $pop->reseller_id);

      $dt = today();

      // dd($dt->day);

      // dd($dt);

      $data['exp']            = date($billing_cycle . '-M-Y');

      // dd($data['exp']);
      $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']) + 1;

      // dd($data['exp_total'] );

      if ($dt->day > $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      } elseif ($dt->day < $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      } elseif ($dt->day == $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      }

      // dd($data['exp_total']);



      // $data['exp_total']++;

      $info['reseller_type'] = Reseller::find($pop->reseller_id)->reseller_type;


      if ($pop->subreseller == 'yes') {


        $subResellerBalance = ExpireCheck::getResellerBalance('pop', $pop->id);
        $subPackage = SubPackage::find($package);
        $price = $subPackage->rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        // $package = $subPackage->id;






        $info['subResellerCost'] = $cost;
        $info['subResellerBalance'] = $subResellerBalance;
        $info['subReseller'] = 'yes';
        $info['sub_reseller_package_id'] = $package;
        $info['sub_reseller_package_price'] = $price;
        $info['sub_reseller_package_name'] = $subPackage->name;

        $resellerPackage = Packages::find($subPackage->package_id);

        $info['reseller_package_id'] = $subPackage->package_id;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_package_price'] = $resellerPackage->package_rate;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      } else {

        $resellerPackage = Packages::find($package);
        $price = $resellerPackage->package_rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        $info['reseller_package_id'] = $package;
        $info['reseller_package_price'] = $price;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      }



      if (config('app.daily_pricing') == false) {

        $data = array_merge($info, [
          'cost' => $price,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => 0
        ]);
      } else {

        $data = array_merge($info, [
          'cost' => $cost,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => $curBalance
        ]);
      }


      return $data;
    } else {
      return '';
    }
  }

  static function expire($pop, $package, $billing_cycle)
  {


    if ($pop != '' && $package != '' && $billing_cycle != '') {

      // dd($package);
      $info['subReseller'] = 'no';


      $curBalance =  ExpireCheck::getResellerBalance('reseller', $pop->reseller_id);

      $dt = today();

      // dd($dt->day);

      // dd($dt);

      $data['exp']            = date($billing_cycle . '-M-Y');

      // dd($data['exp']);
      $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']) + 1;

      // dd($data['exp_total'] );

      if ($dt->day > $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);

      } elseif ($dt->day < $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      } elseif ($dt->day == $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      }


      // dd($data['exp_total']);



      // $data['exp_total']++;




      if ($pop->subreseller == 'yes') {


        $subResellerBalance = ExpireCheck::getResellerBalance('pop', $pop->id);
        $subPackage = SubPackage::find($package);
        $price = $subPackage->rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        // $package = $subPackage->id;




        $info['subResellerCost'] = $cost;
        $info['subResellerBalance'] = $subResellerBalance;
        $info['subReseller'] = 'yes';
        $info['sub_reseller_package_id'] = $package;
        $info['sub_reseller_package_price'] = $price;
        $info['sub_reseller_package_name'] = $subPackage->name;

        $resellerPackage = Packages::find($subPackage->package_id);

        $info['reseller_package_id'] = $subPackage->package_id;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_package_price'] = $resellerPackage->package_rate;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      } else {

        $resellerPackage = Packages::find($package);
        $price = $resellerPackage->package_rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        $info['reseller_package_id'] = $package;
        $info['reseller_package_price'] = $price;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      }



      if (config('app.daily_pricing') == false) {

        $data = array_merge($info, [
          'cost' => $price,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => 0
        ]);

      } else {

        $data = array_merge($info, [
          'cost' => $cost,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => $curBalance
        ]);
      }

      $user = User::find(auth()->user()->id);

      // if($user->user_balance_check = 'yes'){
      $data = array_merge($data, [
        'user_balance' => $user->user_balance,
        'user_balance_check' => $user->user_balance_check
      ]);
      // }


      return $data;
    } else {
      return '';
    }
  }

  static function expireNew($pop, $package, $billing_cycle)
  {


    if ($pop != '' && $package != '' && $billing_cycle != '') {

      // dd($package);
      $info['subReseller'] = 'no';

      $curBalance =  ExpireCheck::getResellerBalance('reseller', $pop->reseller_id);


      $dt = today();
      $data['exp']            = date($billing_cycle . '-M-Y');
      $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']) + 1;

      if ($dt->day > $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp'])+1;

      } elseif ($dt->day < $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp'])+1;
      } elseif ($dt->day == $billing_cycle) {

        $data['exp']        = Carbon::parse($data['exp'])->addMonth()->format('d-M-Y');
        $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp'])+1;
      }

      if(getBillingType() === 'day_to_day'){
        $data['exp_total'] = today()->addDay(30)->diffInDays(today());
      }


      if ($pop->subreseller == 'yes') {


        $subResellerBalance = ExpireCheck::getResellerBalance('pop', $pop->id);
        $subPackage = SubPackage::find($package);
        $price = $subPackage->rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        // $package = $subPackage->id;




        $info['subResellerCost'] = $cost;
        $info['subResellerBalance'] = $subResellerBalance;
        $info['subReseller'] = 'yes';
        $info['sub_reseller_package_id'] = $package;
        $info['sub_reseller_package_price'] = $price;
        $info['sub_reseller_package_name'] = $subPackage->name;

        $resellerPackage = Packages::find($subPackage->package_id);

        $info['reseller_package_id'] = $subPackage->package_id;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_package_price'] = $resellerPackage->package_rate;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);


      } else {

        $resellerPackage = Packages::find($package);
        $price = $resellerPackage->package_rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        $info['reseller_package_id'] = $package;
        $info['reseller_package_price'] = $price;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);

      }



      if (config('app.daily_pricing') == false) {

        $data = array_merge($info, [
          'cost' => $price,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => 0
        ]);

      } else {

        $data = array_merge($info, [
          'cost' => $cost,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => $curBalance
        ]);
      }



      $user = User::find(auth()->user()->id);

      // if($user->user_balance_check = 'yes'){
      $data = array_merge($data, [
        'user_balance' => $user->user_balance,
        'user_balance_check' => $user->user_balance_check
      ]);
      // }

     

      return $data;
    } else {
      return '';
    }
  }


  static function expire_check_for_package_change($pop, $package, $billing_cycle, $expire_date)
  {


    if ($pop != '' && $package != '' && $billing_cycle != '') {

      // dd($package);
      $info['subReseller'] = 'no';


      $curBalance =  ExpireCheck::getResellerBalance('reseller', $pop->reseller_id);

      // dd($curBalance);

      $dt = today();

      $ed = date($billing_cycle . '-M-Y');

      $data['exp'] = $expire_date;

      // if( Carbon::parse($ed) >= Carbon::parse($expire_date) ){


      //   $data['exp']            =  $ed;

      // }elseif(Carbon::parse($ed) < Carbon::parse($expire_date)){

      //   $data['exp']            =  $expire_date;
      // }

      if ((Carbon::parse($ed) == Carbon::parse($expire_date)) && today() == Carbon::parse($ed)) {

        $data['exp_total'] = 0;

      } elseif ((Carbon::parse($ed) == Carbon::parse($expire_date)) && today() < Carbon::parse($ed)) {

        $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']);

      } elseif (Carbon::parse($ed) < Carbon::parse($expire_date)) {

        $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']);

      } else {

        $data['exp_total'] = 0;

      }

      $data['exp_total'] ++;



      // $data['exp_total']      = Carbon::parse($dt)->diffInDays($data['exp']);



      // if($dt->day > $billing_cycle && $dt > Carbon::parse($expire_date)){

      //     $data['exp']        = Carbon::parse($data['exp'] )->addMonth()->format('d-M-Y');
      //     $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp'])+1;

      // }elseif($dt->day <= $billing_cycle ){

      //     $data['exp']        = Carbon::parse($data['exp'] )->format('d-M-Y');
      //     $data['exp_total']  = Carbon::parse($dt)->diffInDays($data['exp']);
      // }



      // $data['exp_total']++;


      if ($pop->subreseller == 'yes') {


        $subResellerBalance = ExpireCheck::getResellerBalance('pop', $pop->id);
        $subPackage = SubPackage::find($package);
        $price = $subPackage->rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        // $package = $subPackage->id;




        $info['subResellerCost'] = $cost;
        $info['subResellerBalance'] = $subResellerBalance;
        $info['subReseller'] = 'yes';
        $info['sub_reseller_package_id'] = $package;
        $info['sub_reseller_package_price'] = $price;
        $info['sub_reseller_package_name'] = $subPackage->name;

        $resellerPackage = Packages::find($subPackage->package_id);

        $info['reseller_package_id'] = $subPackage->package_id;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_package_price'] = $resellerPackage->package_rate;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      } else {

        $resellerPackage = Packages::find($package);
        $price = $resellerPackage->package_rate;
        $cost = PriceCalculate::calculate($dt->daysInMonth, $price, $data['exp_total']);
        $info['reseller_package_id'] = $package;
        $info['reseller_package_price'] = $price;
        $info['reseller_package_name'] = $resellerPackage->package_name;
        $info['reseller_cost'] = PriceCalculate::calculate($dt->daysInMonth, $resellerPackage->package_rate, $data['exp_total']);
      }



      if (config('app.daily_pricing') == false) {

        $data = array_merge($info, [
          'cost' => $price,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => 0
        ]);
      } else {

        $data = array_merge($info, [
          'cost' => $cost,
          'exp_date' => $data['exp'],
          'total_date' => $data['exp_total'],
          'curBalance' => $curBalance
        ]);
      }


      return $data;
    } else {
      return '';
    }
  }
}
